import { OverridableComponent } from '@mui/types';
import { ButtonOwnProps, ButtonTypeMap } from './Button.types';
export interface ButtonOwnerState extends ButtonOwnProps {
    focusVisible: boolean;
    active: boolean;
}
/**
 * The foundation for building custom-styled buttons.
 *
 * Demos:
 *
 * - [Button](https://mui.com/base/react-button/)
 *
 * API:
 *
 * - [Button API](https://mui.com/base/react-button/components-api/#button)
 */
declare const Button: OverridableComponent<ButtonTypeMap<{}, "button">>;
export default Button;
