import * as React from 'react';
import { unstable_useEnhancedEffect as useEnhancedEffect } from '@mui/utils';
import { CompoundComponentContext } from './useCompound';
export function useCompoundItem(id, itemMetadata, missingKeyGenerator) {
  var context = React.useContext(CompoundComponentContext);
  if (context === null) {
    throw new Error('useCompoundItem must be used within a useCompoundParent');
  }
  var registerItem = context.registerItem;
  var _React$useState = React.useState(id),
    registeredId = _React$useState[0],
    setRegisteredId = _React$useState[1];
  useEnhancedEffect(function () {
    var _registerItem = registerItem(id, itemMetadata, missingKeyGenerator),
      returnedId = _registerItem.id,
      deregister = _registerItem.deregister;
    setRegisteredId(returnedId);
    return deregister;
  }, [registerItem, itemMetadata, missingKeyGenerator, id]);
  return {
    id: registeredId,
    index: registeredId !== undefined ? context.getItemIndex(registeredId) : -1,
    totalItemCount: context.totalSubitemCount
  };
}