"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCSV = buildCSV;
var _colDef = require("../../../../colDef");
var _warning = require("../../../../utils/warning");
const serializeCellValue = (value, delimiterCharacter) => {
  if (typeof value === 'string') {
    const formattedValue = value.replace(/"/g, '""');

    // Make sure value containing delimiter or line break won't be split into multiple rows
    if ([delimiterCharacter, '\n', '\r'].some(delimiter => formattedValue.includes(delimiter))) {
      return `"${formattedValue}"`;
    }
    return formattedValue;
  }
  return value;
};
const objectFormattedValueWarning = (0, _warning.buildWarning)(['MUI: When the value of a field is an object or a `renderCell` is provided, the CSV export might not display the value correctly.', 'You can provide a `valueFormatter` with a string representation to be used.']);
const serializeRow = (id, columns, getCellParams, delimiterCharacter) => columns.map(column => {
  const cellParams = getCellParams(id, column.field);
  if (process.env.NODE_ENV !== 'production') {
    if (String(cellParams.formattedValue) === '[object Object]') {
      objectFormattedValueWarning();
    }
  }
  return serializeCellValue(cellParams.formattedValue, delimiterCharacter);
});
function buildCSV(options) {
  const {
    columns,
    rowIds,
    getCellParams,
    delimiterCharacter,
    includeHeaders
  } = options;
  const CSVBody = rowIds.reduce((acc, id) => `${acc}${serializeRow(id, columns, getCellParams, delimiterCharacter).join(delimiterCharacter)}\r\n`, '').trim();
  if (!includeHeaders) {
    return CSVBody;
  }
  const CSVHead = `${columns.filter(column => column.field !== _colDef.GRID_CHECKBOX_SELECTION_COL_DEF.field).map(column => serializeCellValue(column.headerName || column.field, delimiterCharacter)).join(delimiterCharacter)}\r\n`;
  return `${CSVHead}${CSVBody}`.trim();
}