// ** Next Imports
import Head from 'next/head'
import { Router } from 'next/router'

// ** Store Imports
import { store } from 'src/store'
import { Provider } from 'react-redux'

// ** Loader Import
import NProgress from 'nprogress'

// ** Emotion Imports
import { CacheProvider } from '@emotion/react'

// ** Config Imports
import 'src/configs/i18n'
import { defaultACLObj } from 'src/configs/acl'
import themeConfig from 'src/configs/themeConfig'

// ** Third Party Import
import { Toaster } from 'react-hot-toast'

// ** Component Imports
import UserLayout from 'src/layouts/UserLayout'
import AclGuard from 'src/@core/components/auth/AclGuard'
import ThemeComponent from 'src/@core/theme/ThemeComponent'
import AuthGuard from 'src/@core/components/auth/AuthGuard'
import GuestGuard from 'src/@core/components/auth/GuestGuard'

// ** Spinner Import
import Spinner from 'src/@core/components/spinner'

// ** Contexts
import { AuthProvider } from 'src/context/AuthContext'
import { SettingsConsumer, SettingsProvider } from 'src/@core/context/settingsContext'

// ** Styled Components
import ReactHotToast from 'src/@core/styles/libs/react-hot-toast'

// ** Utils Imports
import { createEmotionCache } from 'src/@core/utils/create-emotion-cache'

// ** Prismjs Styles
import 'prismjs'
import 'prismjs/themes/prism-tomorrow.css'
import 'prismjs/components/prism-jsx'
import 'prismjs/components/prism-tsx'

// ** React Perfect Scrollbar Style
import 'react-perfect-scrollbar/dist/css/styles.css'
import 'src/iconify-bundle/icons-bundle-react'

// ** Global css styles
import 'src/styles/globals.css'

// PGN
import backgroundImagePGN from 'public/images/pgn/background.png'

const clientSideEmotionCache = createEmotionCache()

// ** Pace Loader
if (themeConfig.routingLoader) {
  Router.events.on('routeChangeStart', () => {
    NProgress.start()
  })
  Router.events.on('routeChangeError', () => {
    NProgress.done()
  })
  Router.events.on('routeChangeComplete', () => {
    NProgress.done()
  })
}

const Guard = ({ children, authGuard, guestGuard }) => {
  if (guestGuard) {
    return <GuestGuard fallback={<Spinner />}>{children}</GuestGuard>
  } else if (!guestGuard && !authGuard) {
    return <>{children}</>
  } else {
    return <AuthGuard fallback={<Spinner />}>{children}</AuthGuard>
  }
}

// ** Configure JSS & ClassName
const App = props => {
  const { Component, emotionCache = clientSideEmotionCache, pageProps } = props

  // Variables
  const contentHeightFixed = Component.contentHeightFixed ?? false

  const getLayout =
    Component.getLayout ?? (page => <UserLayout contentHeightFixed={contentHeightFixed}>{page}</UserLayout>)
  const setConfig = Component.setConfig ?? undefined
  const authGuard = Component.authGuard ?? true
  const guestGuard = Component.guestGuard ?? false
  const aclAbilities = Component.acl ?? defaultACLObj

  return (
    <Provider store={store}>
      <CacheProvider value={emotionCache}>
        <Head>
          <title>{`${themeConfig.templateName}`}</title>
          <meta name='description' content={`${themeConfig.templateName}`} />
          <meta name='keywords' content='PGN, PGN Register' />
          <meta name='viewport' content='initial-scale=1, width=device-width' />
        </Head>
        <AuthProvider>
          <SettingsProvider {...(setConfig ? { pageSettings: setConfig() } : {})}>
            <SettingsConsumer>
              {({ settings }) => {
                return (
                  <ThemeComponent settings={settings}>
                    <Guard authGuard={authGuard} guestGuard={guestGuard}>
                      <AclGuard aclAbilities={aclAbilities} guestGuard={guestGuard} authGuard={authGuard}>
                        {getLayout(<Component {...pageProps} />)}
                      </AclGuard>
                    </Guard>
                    <ReactHotToast>
                      <Toaster position={settings.toastPosition} toastOptions={{ className: 'react-hot-toast' }} />
                    </ReactHotToast>
                  </ThemeComponent>
                )
              }}
            </SettingsConsumer>
          </SettingsProvider>
        </AuthProvider>
      </CacheProvider>
      <style jsx global>
        {`
          body {
            // use the src property of the image object
            background-image: url(${backgroundImagePGN.src});

            // other styles
            background-position: center center;
            background-size: cover;
            background-repeat: repeat;
            background-attachment: fixed;
            // width: 100vw;
            // height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
          }

          .stepper_dot::after {
            width: 35px;
            height: 0px;
            margin-top: -8px;
          }

          #box_registrasi {
            @media only screen and (min-width: 980px) {
              width: 850px;
            }
            @media only screen and (max-width: 979px) and (min-width: 760px) {
              width: 700px;
            }
          }

          #card_registrasi {
            @media only screen and (min-width: 980px) {
              width: 500px;
            }
            @media only screen and (max-width: 979px) and (min-width: 760px) {
              width: 400px;
            }
            @media only screen and (max-width: 759px) {
              width: 300px;
            }
          }

          #div_parent_step {
            @media only screen and (min-width: 980px) {
              display: flex;
              justify-content: center;
            }
            @media only screen and (max-width: 979px) and (min-width: 760px) {
              display: flex;
              justify-content: center;
            }
            @media only screen and (max-width: 759px) {
            }
          }

          #div_child_step {
            @media only screen and (min-width: 980px) {
              width: 50%;
            }
            @media only screen and (max-width: 979px) and (min-width: 760px) {
              width: 60%;
            }
            @media only screen and (max-width: 759px) {
            }
          }

          #grid_button {
            position: absolute;
            bottom: 0;
            display: flex;
            justify-content: center;

            @media only screen and (min-width: 760px) {
              /* margin-bottom: 90px; */
            }
            @media only screen and (max-width: 759px) {
              /* margin-bottom: 160px; */
            }
          }

          #img_heroManPGN {
            @media only screen and (min-width: 760px) {
              width: 250px;
              position: absolute;
              z-index: 10;
              margin-left: -115px;
              margin-top: 15px;
            }
            @media only screen and (max-width: 759px) {
              display: none;
            }
          }

          #heroPipePGN {
            @media only screen and (min-width: 760px) {
              width: 150px;
              /* height: 200px; */
              position: absolute;
              z-index: 10;
              right: 0;
              margin-right: 70px;
              margin-top: 30px;
            }
            @media only screen and (max-width: 759px) {
              display: none;
            }
          }

          #heroWomanPGN {
            @media only screen and (min-width: 760px) {
              width: 250px;
              /* height: 200px; */
              position: absolute;
              z-index: 10;
              right: 0;
              margin-right: -30px;
              margin-top: 30px;
            }
            @media only screen and (max-width: 759px) {
              display: none;
            }
          }

          .minus-btn:hover,
          .plus-btn:hover {
            background-color: #59addf;
            border-color: #3c6db2;
            color: black;
            cursor: pointer;
          }

          .minus-btn:active,
          .plus-btn:active {
            background-color: #3c6db2;
            transform: scale(0.95);
          }

          #pernyataan-1 span {
            color: white;
          }

          #pernyataan-2 span {
            color: white;
          }

          #media-informasi-sms span {
            color: white;
          }
          #media-informasi-whatsapp span {
            color: white;
          }
          #media-informasi-email span {
            color: white;
          }
          #media-informasi-pgn-mobile span {
            color: white;
          }
        `}
      </style>
    </Provider>
  )
}

export default App
