import { Fragment, useState, useEffect } from 'react'

// ** MUI Components
import Typography from '@mui/material/Typography'
import Box from '@mui/material/Box'
import { styled, useTheme } from '@mui/material/styles'

// ** Layout Import
import BlankLayout from 'src/@core/layouts/BlankLayout'

import StepperKelengkapanData from 'src/views/kelengkapan-data/index.js'
import StepperForm from 'src/views/kelengkapan-data/StepperForm.js'

const RightWrapper = styled(Box)(({ theme }) => ({
  flex: 1,
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  padding: theme.spacing(6),
  backgroundColor: theme.palette.background.paper,
  [theme.breakpoints.up('sm')]: {
    padding: theme.spacing(12)
  }
}))

const Register = () => {
  const [isStepper, setIsStepper] = useState(false)

  const toStepper = () => {
    setIsStepper(true)
  }

  return (
    <Box sx={{ backgroundColor: 'transparent' }}>
      <RightWrapper style={{ backgroundColor: 'transparent' }}>
        <Box sx={{ maxWidth: 900 }} id='box_registrasi'>
          {isStepper ? <StepperForm /> : <StepperKelengkapanData toStepper={toStepper} />}
        </Box>
      </RightWrapper>
    </Box>
  )
}
Register.getLayout = page => <BlankLayout>{page}</BlankLayout>
Register.guestGuard = true

export default Register
