// ** MUI Components
import Typography from '@mui/material/Typography'
import Box from '@mui/material/Box'
import { styled, useTheme } from '@mui/material/styles'

// ** Layout Import
import BlankLayout from 'src/@core/layouts/BlankLayout'

import StepperRegister from 'src/views/register/index.js'

const RightWrapper = styled(Box)(({ theme }) => ({
  flex: 1,
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  padding: theme.spacing(6),
  backgroundColor: theme.palette.background.paper,
  [theme.breakpoints.up('sm')]: {
    padding: theme.spacing(12)
  }
}))

const Register = () => {
  // ** Hooks

  return (
    <Box sx={{ backgroundColor: 'transparent' }}>
      <RightWrapper style={{backgroundColor: 'transparent'}}>
        <Box sx={{ maxWidth: 900 }} id="box_registrasi">
          <StepperRegister />
        </Box>
      </RightWrapper>
    </Box>
  )
}
Register.getLayout = page => <BlankLayout>{page}</BlankLayout>
Register.guestGuard = true

export default Register
