import axios from 'axios'

export const callGet = async (url, params = {}) => {
  try {
    let headers = {
      Authorization: `Bearer ${process.env.NEXT_PUBLIC_API_KEY}`
    }

    const response = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}${url}`, { params, headers })

    return {
      status: true,
      data: response.data
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}

export const callPost = async (url, payload) => {
  try {
    let headers = {
      Authorization: `Bearer ${process.env.NEXT_PUBLIC_API_KEY}`
    }

    const response = await axios.post(`${process.env.NEXT_PUBLIC_API_URL}${url}`, payload, { headers })

    return {
      status: true,
      data: response.data.data,
      message: response.data.message
    }
  } catch (error) {
    if (error.response) {
      console.error('Gagal menghubungkan ke server:', error.response)

      return {
        status: false,
        data: error.response.data,
        message: error.response.data.message
      }
    } else if (error.request) {
      console.error('Tidak ada respons dari server')

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    } else {
      console.error('Gagal menghubungkan ke server:', error.message)

      return {
        status: false,
        data: [],
        message: 'Gagal menghubungkan ke server'
      }
    }
  }
}
