import { createSlice, createAsyncThunk } from '@reduxjs/toolkit'

export const setErrorApi = createAsyncThunk('appRegister/setErrorApi', async (data, { getState, dispatch }) => {
  return data
})

export const setVerifikasiId = createAsyncThunk('appRegister/setVerifikasiId', async (data, { getState, dispatch }) => {
  return data
})

export const setResponseVerifikasiId = createAsyncThunk(
  'appRegister/setResponseVerifikasiId',
  async (data, { getState, dispatch }) => {
    return data
  }
)

export const setKelengkapan = createAsyncThunk('appRegister/setKelengkapan', async (data, { getState, dispatch }) => {
  return data
})

export const setPernyataan = createAsyncThunk('appRegister/setPernyataan', async (data, { getState, dispatch }) => {
  return data
})

export const setResponseKelengkapan = createAsyncThunk(
  'appRegister/setResponseKelengkapan',
  async (data, { getState, dispatch }) => {
    return data
  }
)

export const appKelengkapanDataSlice = createSlice({
  name: 'appRegister',
  initialState: {
    dataErrorApi: {
      data: {},
      message: '',
      status: false
    },
    dataVerifikasiId: '',
    dataResponseVerifikasiId: null,
    dataKelengkapan: {
      nama_pelanggan: '',
      customer_id: '',
      provinsi: '',
      kota: '',
      is_pk: '',
      is_badan_hukum: '',
      is_npwp: '',
      npwp: '',
      ktp: '',
      ktp_file: '',
      nama_ktp: '',
      alamat_ktp: '',
      alamat_lokasi_pemasangan: '',
      no_telpon: '',
      email: '',
      media_informasi: {
        sms: false,
        whatsapp: false,
        email: false,
        pgn_mobile: false
      }
    },
    dataPernyataan: {
      pernyataan_1: false
    },
    dataResponseKelengkapan: null
  },
  reducers: {},

  extraReducers: builder => {
    builder.addCase(setErrorApi.fulfilled, (state, action) => {
      state.dataErrorApi = action.payload
    }),
      builder.addCase(setVerifikasiId.fulfilled, (state, action) => {
        state.dataVerifikasiId = action.payload
      }),
      builder.addCase(setResponseVerifikasiId.fulfilled, (state, action) => {
        state.dataResponseVerifikasiId = action.payload
      }),
      builder.addCase(setKelengkapan.fulfilled, (state, action) => {
        state.dataKelengkapan = action.payload
      }),
      builder.addCase(setPernyataan.fulfilled, (state, action) => {
        state.dataPernyataan = action.payload
      }),
      builder.addCase(setResponseKelengkapan.fulfilled, (state, action) => {
        state.dataResponseKelengkapan = action.payload
      })
  }
})

export default appKelengkapanDataSlice.reducer
