import { createSlice, createAsyncThunk } from '@reduxjs/toolkit'

export const setErrorApi = createAsyncThunk('appRegister/setErrorApi', async (data, { getState, dispatch }) => {
  return data
})

export const setKebutuhan = createAsyncThunk('appRegister/setKebutuhan', async (data, { getState, dispatch }) => {
  return data
})

export const setLokasiPemasangan = createAsyncThunk(
  'appRegister/setLokasiPemasangan',
  async (data, { getState, dispatch }) => {
    return data
  }
)

export const setPenggunaan = createAsyncThunk('appRegister/setPenggunaan', async (data, { getState, dispatch }) => {
  return data
})

export const setPernyataan = createAsyncThunk('appRegister/setPernyataan', async (data, { getState, dispatch }) => {
  return data
})

export const setResponseRegistrasi = createAsyncThunk(
  'appRegister/setResponseRegistrasi',
  async (data, { getState, dispatch }) => {
    return data
  }
)

export const setKonten = createAsyncThunk('appRegister/setKonten', async (data, { getState, dispatch }) => {
  return data
})

export const setDataMap = createAsyncThunk('appRegister/setDataMap', async (data, { getState, dispatch }) => {
  return data
})

export const appRegisterSlice = createSlice({
  name: 'appRegister',
  initialState: {
    dataErrorApi: {
      data: {},
      message: '',
      status: false
    },
    dataKebutuhan: '1',
    dataLokasiPemasangan: {
      provinsi: null,
      kota: null,
      kecamatan: null,
      kelurahan: null,
      select_perumahan_jalan_utama: null,
      nama_perumahan_jalan_utama: '',
      rt: '',
      rw: '',
      kode_pos: '',
      alamat: '',
      jenis_bangunan: null,
      status_lokasi_pemasangan: 0,
      status_kepemilikan: null,
      nama_pemilik_bangunan: '',
      no_telpon: '',
      latitude: -6.2088,
      longitude: 106.8456,
      maps: 1,
      tagging_map: false
    },
    dataPenggunaan: {
      nama: '',
      ktp: '',
      no_telpon: '',
      email: '',
      ktp_file: null,
      energi_listrik: null,
      rekening_listrik_file: null,
      bahan_bakar: [],
      peralatan: []
    },
    dataPernyataan: {
      pernyataan_1: false,
      pernyataan_2: false,
      pernyataan_3: false
    },
    dataResponseRegistrasi: null,
    dataKonten: null,
    dataMap: 1
  },
  reducers: {},

  extraReducers: builder => {
    builder.addCase(setErrorApi.fulfilled, (state, action) => {
      state.dataErrorApi = action.payload
    }),
      builder.addCase(setKebutuhan.fulfilled, (state, action) => {
        state.dataKebutuhan = action.payload
      }),
      builder.addCase(setLokasiPemasangan.fulfilled, (state, action) => {
        state.dataLokasiPemasangan = action.payload
      }),
      builder.addCase(setPenggunaan.fulfilled, (state, action) => {
        state.dataPenggunaan = action.payload
      }),
      builder.addCase(setPernyataan.fulfilled, (state, action) => {
        state.dataPernyataan = action.payload
      }),
      builder.addCase(setResponseRegistrasi.fulfilled, (state, action) => {
        state.dataResponseRegistrasi = action.payload
      }),
      builder.addCase(setKonten.fulfilled, (state, action) => {
        state.dataKonten = action.payload
      }),
      builder.addCase(setDataMap.fulfilled, (state, action) => {
        state.dataMap = action.payload
      })
  }
})

export default appRegisterSlice.reducer
