import Fab from '@mui/material/Fab'

const StepperCustomDot = props => {
  // ** Props
  const { active, completed, error, icon } = props

  const style_stepper_dot = {
    width: '35px',
    height: '0px',
    marginTop: '-8px'
  }

  if (error) {
    return (
      <Fab color='error' aria-label='add' size='small' style={style_stepper_dot}>
        {icon}
      </Fab>
    )
  } else if (completed) {
    return (
      <Fab color='success' aria-label='add' size='small' style={style_stepper_dot}>
        {icon}
      </Fab>
    )
  } else {
    if (active) {
      return (
        <Fab color='success' aria-label='add' size='small' style={style_stepper_dot}>
          {icon}
        </Fab>
      )
    }

    return (
      <Fab color='primary' aria-label='add' size='small' style={style_stepper_dot}>
        {icon}
      </Fab>
    )
  }
}

export default StepperCustomDot
