// ** React Imports
import { Fragment, useState, useEffect } from 'react'

// ** MUI Imports
import Box from '@mui/material/Box'
import Card from '@mui/material/Card'
import Step from '@mui/material/Step'
import Grid from '@mui/material/Grid'
import Button from '@mui/material/Button'
import Stepper from '@mui/material/Stepper'
import StepLabel from '@mui/material/StepLabel'
import Typography from '@mui/material/Typography'
import CardContent from '@mui/material/CardContent'
import Radio from '@mui/material/Radio'
import RadioGroup from '@mui/material/RadioGroup'
import FormControlLabel from '@mui/material/FormControlLabel'
import StepperCustomDot from './StepperCustomDot'
import toast from 'react-hot-toast'
import CustomTextField from 'src/@core/components/mui/text-field'

import Dialog from '@mui/material/Dialog'
import DialogTitle from '@mui/material/DialogTitle'
import DialogContent from '@mui/material/DialogContent'
import DialogActions from '@mui/material/DialogActions'
import DialogContentText from '@mui/material/DialogContentText'

import { styled } from '@mui/material/styles'
import CircularProgress from '@mui/material/CircularProgress'

// PGN
import StepperWrapper from 'src/@core/styles/mui/stepper'
import FormKelengkapan from './components/FormKelengkapan'
import FormReview from './components/FormReview'
import FormVerifikasiId from './components/FormVerifikasiId'

import heroManPGN from 'public/images/pgn/pgn_hero_man.png'
import heroWomanPGN from 'public/images/pgn/pgn_hero_women.png'
import heroPipePGN from 'public/images/pgn/pgn_hero_pipe.png'
import textGaskitaWhite from 'public/images/pgn/text_gaskita_white.png'
import heroPackagePGN from 'public/images/pgn/pgn_hero_package.png'
import successPGN from 'public/images/pgn/success.png'
import failedPGN from 'public/images/pgn/failed.png'
import warningPGN from 'public/images/pgn/warning.png'

import { useDispatch, useSelector } from 'react-redux'
import {
  setErrorApi,
  setVerifikasiId,
  setResponseVerifikasiId,
  setResponseKelengkapan
} from 'src/store/apps/kelengkapan-data'

import { callPost } from 'src/service/api'
import { Endpoint, ValidateRequiredMessageKelengkapanData } from 'src/service/constant'

const steps = [
  {
    title: 'Verifikasi ID',
    subtitle: ''
  },
  {
    title: 'Kelengkapan',
    subtitle: ''
  },
  {
    title: 'Review',
    subtitle: ''
  }
]

const StepperRegister = () => {
  const [activeStep, setActiveStep] = useState(0)
  const [heightCard, setHeightCard] = useState('500px')

  const [state, setState] = useState({
    password: '',
    password2: '',
    showPassword: false,
    showPassword2: false
  })

  const dispatch = useDispatch()
  const store = useSelector(state => state.kelengkapanData)

  const [openSubmit, setOpenSubmit] = useState(false)
  const [textLoading, setTextLoading] = useState('Memuat data...')
  const handleCloseSubmit = () => setOpenSubmit(false)

  const [openDuplicate, setOpenDuplicate] = useState(false)
  const handleCloseDuplicate = () => setOpenDuplicate(false)

  const [openSuccess, setOpenSuccess] = useState(false)

  const handleCloseSuccess = () => {
    window.location.reload()
  }

  const [openFailed, setOpenFailed] = useState(false)
  const handleCloseFailed = () => setOpenFailed(false)

  const [openConfirm, setOpenConfirm] = useState(false)

  const handleCloseConfirm = () => {
    setOpenConfirm(false)
    handleClickSubmit()
  }

  const handleClickSubmit = async () => {
    dispatch(
      setErrorApi({
        data: {},
        message: '',
        status: false
      })
    )

    setOpenSubmit(true)

    setOpenSuccess(false)
    setOpenFailed(false)

    const payload = new FormData()

    payload.append('nama_pelanggan', store.dataKelengkapan.nama_pelanggan)
    payload.append('customer_id', store.dataKelengkapan.customer_id)
    payload.append('provinsi', store.dataKelengkapan.provinsi.id)
    payload.append('kota', store.dataKelengkapan.kota.id)
    payload.append('is_pk', store.dataKelengkapan.is_pk != '' ? store.dataKelengkapan.is_pk : '0')
    payload.append(
      'is_badan_hukum',
      store.dataKelengkapan.is_badan_hukum != '' ? store.dataKelengkapan.is_badan_hukum : '0'
    )
    payload.append('is_npwp', store.dataKelengkapan.is_npwp != '' ? store.dataKelengkapan.is_npwp : '0')
    payload.append('npwp', store.dataKelengkapan.npwp)
    payload.append('ktp', store.dataKelengkapan.ktp)
    payload.append('ktp_file', store.dataKelengkapan.ktp_file)
    payload.append('nama_ktp', store.dataKelengkapan.nama_ktp)
    payload.append('alamat_ktp', store.dataKelengkapan.alamat_ktp)
    payload.append('alamat_lokasi_pemasangan', store.dataKelengkapan.alamat_lokasi_pemasangan)
    payload.append('no_telpon', store.dataKelengkapan.no_telpon.replaceAll('+', '').replaceAll(' ', ''))
    payload.append('email', store.dataKelengkapan.email)

    const responseSubmit = await callPost(Endpoint.postKelengkapanData, payload)
    setOpenSubmit(false)
    if (!responseSubmit.status) {
      if (responseSubmit.message == 'duplicate data') {
        // setOpenDuplicate(true)
      } else if (responseSubmit.message == 'Failed validation') {
        dispatch(
          setErrorApi({
            data: responseSubmit.data,
            message: responseSubmit.message,
            status: true
          })
        )
      } else {
        setOpenFailed(true)
      }
    } else {
      dispatch(
        setResponseKelengkapan({
          data: responseSubmit.data,
          message: responseSubmit.message,
          status: true
        })
      )

      // setActiveStep(4)

      setOpenSuccess(true)

      // handleReset()
    }
  }

  useEffect(() => {
    // console.log("store = ",store)
  }, [dispatch, store])

  useEffect(() => {
    if (store.dataErrorApi.status) {
      if (store.dataErrorApi.data.errors) {
        for (let field in store.dataErrorApi.data.errors) {
          let errorMessages = store.dataErrorApi.data.errors[field]
          errorMessages.forEach(errorMessage => {
            toast.error(errorMessage)
          })
        }
      } else {
        toast.error(store.dataErrorApi.message)
      }
    }
  }, [dispatch, store.dataErrorApi])

  useEffect(() => {
    if (activeStep > 0) {
      setHeightCard('auto')
    } else {
      setHeightCard('500px')
    }
  }, [activeStep])

  // Handle Stepper
  const handleBack = () => {
    if (activeStep > 0) {
      setActiveStep(prevActiveStep => prevActiveStep - 1)
    }
  }

  const handleNext = () => {
    if (formValidate(activeStep)) {
      if (activeStep === 2) {
        // handleClickSubmit()
        setOpenConfirm(true)
      } else {
        setActiveStep(prevActiveStep => prevActiveStep + 1)
      }
    }
  }

  // STATE PGN

  const validateEmail = email => {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/

    return emailRegex.test(email)
  }

  const formValidate = step => {
    switch (step) {
      case 0:
        return formValidateVerifikasiId()
      case 1:
        return formValidateKelengkapan()
      case 2:
        return formValidatePernyataan()
    }
  }

  const callVerikasiId = async () => {
    dispatch(
      setErrorApi({
        data: [],
        message: '',
        status: false
      })
    )

    setOpenSubmit(true)
    setTextLoading('Memverifikasi data...')

    const payload = {
      reference_id: store.dataVerifikasiId
    }

    const response = await callPost(Endpoint.postVerifikasiId, payload)
    if (!response.status) {
      dispatch(
        setErrorApi({
          data: response.data,
          message: response.message,
          status: true
        })
      )
    } else {
      dispatch(
        setResponseVerifikasiId({
          data: response.data,
          message: response.message,
          status: true
        })
      )

      setActiveStep(1)
    }

    setOpenSubmit(false)
    setTextLoading('Memuat data...')
  }

  const formValidateVerifikasiId = () => {
    if (store.dataVerifikasiId == '') {
      toast.error(ValidateRequiredMessageKelengkapanData.dataVerifikasiId)

      return false
    } else {
      callVerikasiId()
    }

    return false
  }

  const formValidateKelengkapan = () => {
    const requiredFields = [
      'nama_pelanggan',
      'customer_id',
      'provinsi',
      'kota',
      'is_pk',
      'is_badan_hukum',
      'is_npwp',
      'npwp',
      'ktp',
      'ktp_file',
      'nama_ktp',
      'alamat_ktp',
      'alamat_lokasi_pemasangan',
      'no_telpon'
    ]

    for (const field of requiredFields) {
      if (field == 'is_badan_hukum') {
        if (store.dataKelengkapan['is_pk'] === 1 && store.dataKelengkapan[field] === '') {
          toast.error(ValidateRequiredMessageKelengkapanData[field])

          return false
        }
      } else {
        if (store.dataKelengkapan[field] === '') {
          toast.error(ValidateRequiredMessageKelengkapanData[field])

          return false
        }
      }
    }

    if (store.dataKelengkapan.email != '') {
      if (!validateEmail(store.dataKelengkapan.email)) {
        toast.error(ValidateRequiredMessageKelengkapanData.email_format)

        return false
      }
    }

    return true
  }

  const formValidatePernyataan = () => {
    if (store.dataPernyataan.pernyataan_1 == false) {
      toast.error(ValidateRequiredMessageKelengkapanData.pernyataan)

      return false
    }

    return true
  }

  const getStepContent = step => {
    switch (step) {
      case 0:
        return <FormVerifikasiId />
      case 1:
        return <FormKelengkapan />
      case 2:
        return <FormReview />
      default:
        return <FormReview />
    }
  }

  const renderContent = () => {
    return (
      <form onSubmit={e => e.preventDefault()} style={{ height: '100%', width: '100%' }}>
        <Grid
          container
          spacing={5}
          style={{ display: 'flex', justifyContent: 'center', position: 'relative', height: '100%' }}
        >
          <LoadingSubmit />
          {/* <AlertDataDuplicate /> */}
          <AlertSubmitSuccess />
          <AlertSubmitFailed />
          <AlertSubmitConfirm />

          {getStepContent(activeStep)}

          <Grid item xs={12} id='grid_button'>
            {activeStep != 0 && (
              <Button
                variant='outlined'
                color='secondary'
                size='small'
                onClick={handleBack}
                style={{ borderRadius: '25px', width: '130px' }}
              >
                <span style={{ fontSize: '14px' }}>Kembali</span>
              </Button>
            )}

            <Button
              variant='contained'
              color='success'
              size='small'
              onClick={handleNext}
              sx={{ ml: 5 }}
              style={{ borderRadius: '25px', width: '130px' }}
            >
              <span style={{ fontSize: '14px' }}>{activeStep === 2 ? 'Simpan' : 'Lanjut'}</span>
            </Button>
          </Grid>
        </Grid>
      </form>
    )
  }

  const AlertDataDuplicate = () => {
    return (
      <Fragment>
        <Dialog
          open={openDuplicate}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseDuplicate()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid item xs={12} sm={4} style={{ textAlign: 'center' }}>
              <img
                src={heroPackagePGN.src}
                alt=''
                id='img_heroPackagePGN'
                style={{ paddingTop: '10px', paddingBottom: '10px' }}
              ></img>
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Informasi Pendaftaran
              </DialogTitle>
              <DialogContent>
                <DialogContentText id='alert-submit-description'>
                  Pelanggan yang terhormat, data anda sudah digunakan untuk pendaftaran sebelumnya dan pada saat ini
                  sedang dalam proses persetujuan. Silakan cek status menggunakan PGN Mobile
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='outlined'
                  color='primary'
                  size='small'
                  onClick={handleCloseDuplicate}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Kembali
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const AlertSubmitSuccess = () => {
    return (
      <Fragment>
        <Dialog
          open={openSuccess}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseSuccess()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img src={successPGN.src} alt='' id='img_successPGN' style={{ paddingTop: '30px', width: '150px' }} />
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Sukses Melakukan Pembaruan Data
              </DialogTitle>
              <DialogContent style={{ marginBottom: '50px' }}>
                <DialogContentText id='alert-submit-description'>
                  Data Anda berhasil diperbaharui. Terima kasih atas partisipasi Anda.
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={handleCloseSuccess}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  OK
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const AlertSubmitFailed = () => {
    return (
      <Fragment>
        <Dialog
          open={openFailed}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseFailed()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img src={failedPGN.src} alt='' id='img_failedPGN' style={{ paddingTop: '30px', width: '150px' }} />
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Gagal Melakukan Pembaruan Data
              </DialogTitle>
              <DialogContent>
                <DialogContentText id='alert-submit-description'>
                  Pembaruan Data Anda gagal tersimpan, silakan mencoba beberapa saat lagi. Informasi lebih lanjut
                  hubungi Pertamina Call Center 135 atau WhatsApp 08151-1500645 (hanya menerima pesan)
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='outlined'
                  color='primary'
                  size='small'
                  onClick={handleCloseFailed}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  OK
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const AlertSubmitConfirm = () => {
    return (
      <Fragment>
        <Dialog
          open={openConfirm}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseConfirm()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img src={warningPGN.src} alt='' id='img_warningPGN' style={{ paddingTop: '30px', width: '150px' }} />
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Konfirmasi Pembaruan Data
              </DialogTitle>
              <DialogContent style={{ marginBottom: '50px' }}>
                <DialogContentText id='alert-submit-description'>
                  Pastikan Anda telah mengisi data dengan BENAR dan LENGKAP.
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='outlined'
                  color='primary'
                  size='small'
                  onClick={() => setOpenConfirm(false)}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Kembali
                </Button>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={handleCloseConfirm}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Simpan
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const CircularProgressIndeterminate = styled(CircularProgress)(({ theme }) => ({
    left: 0,
    position: 'relative',
    animationDuration: '1000ms',
    color: theme.palette.mode === 'light' ? '#1a90ff' : '#308fe8'
  }))

  const LoadingSubmit = () => {
    return (
      <Fragment>
        <Dialog
          open={openSubmit}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseSubmit()
            }
          }}
        >
          <DialogContent style={{ textAlign: 'center' }}>
            <Box
              sx={{
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                position: 'relative'
              }}
            >
              <CircularProgressIndeterminate variant='indeterminate' disableShrink size={50} thickness={5} />
            </Box>
            <p style={{ color: 'primary', fontSize: '12pt' }}>{textLoading}</p>
          </DialogContent>
        </Dialog>
      </Fragment>
    )
  }

  return (
    <Fragment>
      <div id='div_parent_step'>
        <StepperWrapper id='div_child_step'>
          <Stepper activeStep={activeStep} alternativeLabel>
            {steps.map((step, index) => {
              return (
                <Step key={index}>
                  <StepLabel StepIconComponent={StepperCustomDot}>
                    <div className='step-label'>
                      <div>
                        <Typography className='step-title' style={{ color: 'white', fontSize: '10pt' }}>
                          {step.title}
                        </Typography>
                      </div>
                    </div>
                  </StepLabel>
                </Step>
              )
            })}
          </Stepper>
        </StepperWrapper>
      </div>

      <Card
        sx={{ mt: 4 }}
        style={{ backgroundColor: '#3C6DB2', minHeight: '500px', height: heightCard, color: 'white' }}
      >
        <CardContent style={{ height: '100%' }}>
          <div style={{ display: 'flex', width: '100%', height: '100%' }}>{renderContent()}</div>
        </CardContent>
      </Card>
    </Fragment>
  )
}

export default StepperRegister
