// ** React Imports
import { forwardRef, useState, Fragment, useEffect, useRef } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Fab from '@mui/material/Fab'
import Checkbox from '@mui/material/Checkbox'
import FormControlLabel from '@mui/material/FormControlLabel'
import Button from '@mui/material/Button'
import DialogTitle from '@mui/material/DialogTitle'
import DialogContent from '@mui/material/DialogContent'
import DialogActions from '@mui/material/DialogActions'
import Dialog from '@mui/material/Dialog'
import DialogContentText from '@mui/material/DialogContentText'
import CustomTextField from 'src/@core/components/mui/text-field'
import Typography from '@mui/material/Typography'

import { useDispatch, useSelector } from 'react-redux'
import { setErrorApi, setPernyataan } from 'src/store/apps/kelengkapan-data'

const FormReview = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.kelengkapanData)

  const styleText = {
    color: 'white'
  }

  const style_stepper_dot = {
    minWidth: '35px',
    height: '0px',
    marginTop: '',
    marginRight: '10px',
    fontSize: '15pt'
  }

  const [dataPernyataan, setdataPernyataan] = useState({
    pernyataan_1: false
  })

  useEffect(() => {
    window.scrollTo({
      top: 0,
      behavior: 'smooth'
    })
  }, [])

  const setStateLocal = (key, value) => {
    setdataPernyataan(prevState => ({
      ...prevState,
      [key]: value
    }))
  }

  useEffect(() => {
    dispatch(setPernyataan(dataPernyataan))
  }, [dataPernyataan])

  const handleChangePernyataan = (event, action) => {
    setStateLocal(action, event.target.checked)
  }

  // DIALOG
  const [openKebenaranData, setOpenKebenaranData] = useState(false)
  const [openKetentuan, setOpenKetentuan] = useState(false)
  const descriptionElementRef = useRef(null)

  const handleClickOpenPernyataan = action => {
    setOpenKebenaranData(false)
    setOpenKetentuan(false)

    switch (action) {
      case 'pernyataan_1':
        setOpenKebenaranData(true)
        break

      case 'pernyataan_2':
        setOpenKetentuan(true)
        break
    }
  }

  return (
    <Fragment>
      <div style={{ padding: '10px', marginLeft: '10px', minHeight: '500px', width: '100%', paddingBottom: '80px' }}>
        <div style={{ textAlign: 'center' }}>
          <h1>Review</h1>
          <Typography style={styleText}></Typography>
        </div>
        <Grid container spacing={5}>
          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Nama Pelanggan yang terdaftar di PGN'
              placeholder='Nama Pelanggan'
              value={store.dataKelengkapan.nama_pelanggan}
              InputProps={{ readOnly: true }}
            />
          </Grid>
          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Nomor ID Pelanggan PGN'
              placeholder='Nomor ID Pelanggan PGN'
              value={store.dataKelengkapan.customer_id}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Provinsi'
              placeholder='Provinsi'
              value={store.dataKelengkapan.provinsi?.name}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Kota/Kabupaten'
              placeholder='Kota/Kabupaten'
              value={store.dataKelengkapan.kota?.name}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Apakah Anda Pelanggan Kecil (PK) ?'
              placeholder='Ya/Tidak'
              value={store.dataKelengkapan.is_pk == 1 ? 'Ya' : 'Tidak'}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          {store.dataKelengkapan.is_pk == 1 && (
            <Grid item xs={12} sm={6}>
              <CustomTextField
                fullWidth
                label='Apakah Usaha Anda Berbadan Hukum ?'
                placeholder='Ya/Tidak'
                value={store.dataKelengkapan.is_badan_hukum == 1 ? 'Ya' : 'Tidak'}
                InputProps={{ readOnly: true }}
              />
            </Grid>
          )}

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Apakah Anda Memiliki NPWP ?'
              placeholder='Ya/Tidak'
              value={store.dataKelengkapan.is_npwp == 1 ? 'Ya' : 'Tidak'}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='NPWP Pelanggan'
              placeholder='NPWP Pelanggan'
              value={store.dataKelengkapan.npwp}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='NIK Pelanggan'
              placeholder='NIK Pelanggan'
              value={store.dataKelengkapan.ktp}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Nama Sesuai NIK / NPWP'
              placeholder='Nama Sesuai NIK / NPWP'
              value={store.dataKelengkapan.nama_ktp}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Alamat Sesuai NIK / NPWP'
              placeholder='Alamat Sesuai NIK / NPWP'
              value={store.dataKelengkapan.alamat_ktp}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Alamat Lokasi Pemasangan'
              placeholder='Alamat Lokasi Pemasangan'
              value={store.dataKelengkapan.alamat_lokasi_pemasangan}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='No. HP / WhatsApp'
              placeholder='No. HP / WhatsApp'
              value={store.dataKelengkapan.no_telpon}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              fullWidth
              label='Email'
              placeholder='Email'
              value={store.dataKelengkapan.email}
              InputProps={{ readOnly: true }}
            />
          </Grid>

          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <div>
                <FormControlLabel
                  id='pernyataan-1'
                  sx={{ '& svg': { height: 30, width: 30, stroke: 'white' } }}
                  control={<Checkbox onChange={e => handleChangePernyataan(e, 'pernyataan_1')} />}
                ></FormControlLabel>
              </div>
              <div style={{ marginLeft: '-20px' }}>
                <span
                  onClick={e => handleClickOpenPernyataan('pernyataan_1')}
                  style={{ cursor: 'pointer', color: 'white' }}
                >
                  Saya menyatakan data yang disampaikan adalah yang sebenar-benarnya *
                </span>
              </div>
            </div>
          </Grid>
        </Grid>
      </div>
    </Fragment>
  )
}

export default FormReview
