// ** React Imports
import { forwardRef, useState, Fragment, useEffect, useRef } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Typography from '@mui/material/Typography'
import CustomTextField from 'src/@core/components/mui/text-field'

import { useDispatch, useSelector } from 'react-redux'
import { setErrorApi, setVerifikasiId } from 'src/store/apps/kelengkapan-data'

const FormVerifikasiId = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.kelengkapanData)

  const [verifId, setVerifId] = useState('')

  useEffect(() => {
    // console.log("store = ",store)
  }, [dispatch, store])

  const changeVerifId = event => {
    setVerifId(event.target.value)
    dispatch(setVerifikasiId(event.target.value))
  }

  return (
    <Fragment>
      <div style={{ padding: '10px', marginLeft: '10px', minHeight: '500px', width: '100%', paddingBottom: '80px' }}>
        <div style={{ textAlign: 'center' }}>
          <h1>Verifikasi ID</h1>
          <Typography style={{ color: 'white' }}></Typography>
        </div>

        <Grid container spacing={5}>
          <Grid item xs={12} sm={6}>
            <span style={{ fontSize: '11pt' }}>
              <b>ID Pelanggan</b> dan <b>3 huruf (karakter) nama depan Anda</b> (tanpa spasi dan tanda baca) *
            </span>
          </Grid>
          <Grid item xs={12} sm={6}>
            <CustomTextField fullWidth label='' placeholder='123456789CUS' value={verifId} onChange={changeVerifId} />
          </Grid>

          <Grid item xs={12} sm={6}>
            <span style={{ fontSize: '11pt' }}>Contoh :</span>
            <div style={{ paddingTop: '10px' }}>
              <table>
                <tbody>
                  <tr>
                    <td width={120}>ID Pelanggan</td>
                    <td>: &ensp; 123456789</td>
                  </tr>
                  <tr>
                    <td>Nama</td>
                    <td>: &ensp; Siti Aisah</td>
                  </tr>
                  <tr>
                    <td>Input</td>
                    <td>: &ensp; 123456789SIT</td>
                  </tr>
                </tbody>
              </table>
            </div>
          </Grid>
        </Grid>
      </div>
    </Fragment>
  )
}

export default FormVerifikasiId
