// ** React Imports
import { Fragment, useState, useEffect } from 'react'

// ** MUI Imports
import Card from '@mui/material/Card'
import Button from '@mui/material/Button'
import Typography from '@mui/material/Typography'
import CardContent from '@mui/material/CardContent'

// PGN
import pgnLogo from 'public/images/pgn-long.png'

import { useDispatch, useSelector } from 'react-redux'

const StepperKelengkapanData = props => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  return (
    <Fragment>
      <Card sx={{ mt: 4 }} style={{ backgroundColor: 'white', minHeight: '500px', height: '500px', color: 'white' }}>
        <div style={{ backgroundColor: '#70B1EC', height: '20px' }}></div>
        <CardContent
          style={{ height: '100%', display: 'flex', flexDirection: 'column', justifyContent: 'space-between' }}
        >
          <div style={{ paddingTop: '50px' }}>
            <img src={pgnLogo.src} alt='' width={250} />
          </div>
          <div style={{ marginTop: '-100px' }}>
            <Typography className='step-title' style={{ color: '#3C6DB2', fontSize: '14pt' }}>
              Halo Sobat Energi Baik! Klik <b>LANJUTKAN</b> untuk melakukan pengkinian data pelanggan Anda.
            </Typography>
          </div>
          <div style={{ alignSelf: 'flex-end', marginBottom: '20px' }}>
            <Button
              variant='contained'
              color='success'
              size='small'
              style={{ borderRadius: '25px', width: '180px' }}
              onClick={e => props.toStepper()}
            >
              <span style={{ fontSize: '14pt' }}>Lanjutkan</span>
            </Button>
          </div>
        </CardContent>
      </Card>
    </Fragment>
  )
}

export default StepperKelengkapanData
