// DigioMaps.js
import React, { useState, useEffect, useRef } from 'react'

const DigioMaps = ({ latitude, longitude, dataLokasiPemasangan, setStateLocal, onError }) => {
  const iframeRef = useRef(null)

  useEffect(() => {
    const handleMessageFromIframe = event => {
      if (event.source === iframeRef.current.contentWindow) {
        const message = event.data

        if (message && message.latitude && message.longitude) {
          setStateLocal('latitude', message.latitude)
          setStateLocal('longitude', message.longitude)

          if (message.Status == null || message.Status == 0) {
            setStateLocal('tagging_map', true)
          } else {
            setStateLocal('tagging_map', false)
          }
        }
      }
    }

    window.addEventListener('message', handleMessageFromIframe)

    // Bersihkan event listener saat komponen tidak lagi dirender
    return () => {
      window.removeEventListener('message', handleMessageFromIframe)
    }
  }, [])

  useEffect(() => {
    const handleIframeError = () => {
      console.log('Error occurred while loading DigioMaps.')
      onError() // Memanggil fungsi onError yang diterima dari ParentComponent
    }

    const iframe = document.getElementById('iframe-digio')
    if (iframe) {
      iframe.addEventListener('error', handleIframeError)

      return () => {
        iframe.removeEventListener('error', handleIframeError)
      }
    }
  }, [onError])

  return (
    <div>
      <iframe
        ref={iframeRef}
        id='iframe-digio'
        src={process.env.NEXT_PUBLIC_DIGIO_URL}
        title='digio_maps'
        width='100%'
        height='400px'
      ></iframe>
    </div>
  )
}

export default DigioMaps
