// DigioMaps.js
import React, { useState, useEffect, useRef } from 'react'

const DigioMaps = ({ latitude, longitude, dataLokasiPemasangan, setStateLocal, onError }) => {
  const iframeRef = useRef(null)

  useEffect(() => {
    const handleMessageFromIframe = event => {
      if (event.source === iframeRef.current.contentWindow) {
        const message = event.data

        if (message && message.latitude && message.longitude) {
          // setStateLocal('latitude', message.latitude)
          // setStateLocal('longitude', message.longitude)
          // console.log('Message from iframe:', message)
        }
      }
    }

    window.addEventListener('message', handleMessageFromIframe)

    // Bersihkan event listener saat komponen tidak lagi dirender
    return () => {
      window.removeEventListener('message', handleMessageFromIframe)
    }
  }, [])

  useEffect(() => {
    const handleIframeError = () => {
      console.log('Error occurred while loading DigioMaps.')
      onError() // Memanggil fungsi onError yang diterima dari ParentComponent
    }

    const iframe = document.getElementById('iframe-digio')
    if (iframe) {
      iframe.addEventListener('error', handleIframeError)

      return () => {
        iframe.removeEventListener('error', handleIframeError)
      }
    }
  }, [onError])

  // Simulasi kegagalan memuat iframe
  const [simulateError, setSimulateError] = useState(false)
  useEffect(() => {
    if (simulateError) {
      onError()
    }
  }, [simulateError, onError])

  // Fungsi untuk mensimulasikan kegagalan
  const simulateIframeError = () => {
    setSimulateError(true)
  }

  // Kembalikan null jika terjadi kesalahan simulasi
  if (simulateError) {
    return null
  }

  return (
    <div style={{ position: 'relative', height: '400px' }}>
      <div
        style={{
          position: 'absolute',
          top: 0,
          left: 0,
          width: '100%',

          height: '100%',
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          backgroundColor: 'rgb(187 187 187 / 50%)',
          zIndex: 1100
        }}
      ></div>
      <iframe
        ref={iframeRef}
        id='iframe-digio'
        src={process.env.NEXT_PUBLIC_DIGIO_URL}
        title='digio_maps'
        width='100%'
        height='400px'
      ></iframe>
    </div>
  )
}

export default DigioMaps
