// ** React Imports
import { forwardRef, useState, Fragment, useEffect, useRef } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Typography from '@mui/material/Typography'
import Paper from '@mui/material/Paper'
import Table from '@mui/material/Table'
import TableRow from '@mui/material/TableRow'
import TableHead from '@mui/material/TableHead'
import TableBody from '@mui/material/TableBody'
import TableCell from '@mui/material/TableCell'
import TableContainer from '@mui/material/TableContainer'
import Fab from '@mui/material/Fab'

import { useDispatch, useSelector } from 'react-redux'
import { setErrorApi, setPernyataan } from 'src/store/apps/register'

const FormBerhasil = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  useEffect(() => {
    window.scrollTo({
      top: 0,
      behavior: 'smooth'
    })
    console.log(store.dataResponseRegistrasi)
  }, [])

  const styleText = {
    color: 'white'
  }

  const style_stepper_dot = {
    maxWidth: '35px',
    minWidth: '35px',
    height: '0px',
    marginTop: '',
    marginRight: '10px',
    fontSize: '10pt'
  }

  const FiturKomponen = () => {
    if (
      store.dataResponseRegistrasi &&
      store.dataResponseRegistrasi.data &&
      store.dataResponseRegistrasi.data.katalog_produk.length > 0
    ) {
      return (
        <Fragment>
          <div style={{ display: 'flex', alignItems: 'center' }}>
            <h3>Fitur Produk</h3>
            <div
              style={{
                flex: 1,
                height: '1px',
                backgroundColor: 'white', // Set the color of the divider
                margin: '0 10px' // Adjust margin as needed
              }}
            ></div>
          </div>
          <table
            style={{
              width: '100%'
            }}
          >
            <tbody>
              {store.dataResponseRegistrasi.data.katalog_produk[0].features.map((item, index) => (
                <tr key={`features-${index}`}>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid white',
                      padding: '8px',
                      backgroundColor: 'white',
                      color: 'black',
                      fontSize: '10pt',
                      borderTopLeftRadius: '6px',
                      borderBottomLeftRadius: '6px'
                    }}
                  >
                    <div style={{ display: 'flex', alignItems: 'center' }}>
                      <Fab color='primary' aria-label='add' size='small' style={style_stepper_dot}>
                        {index + 1}
                      </Fab>
                      {item.feature.name}
                    </div>
                  </td>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid white',
                      padding: '8px',
                      backgroundColor: 'transparent',
                      fontSize: '10pt',
                      minHeight: '40px',
                      borderTopRightRadius: '6px',
                      borderBottomRightRadius: '6px'
                    }}
                  >
                    {item.description}
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
          <style jsx>{`
            @media (max-width: 600px) {
              /* Atur lebar kolom menjadi 100% pada tampilan mobile */
              table td {
                width: 100% !important;
                display: block;
                box-sizing: border-box;
              }
            }
          `}</style>
        </Fragment>
      )
    }
  }

  const FiturKetentuan = () => {
    if (
      store.dataResponseRegistrasi &&
      store.dataResponseRegistrasi.data &&
      store.dataResponseRegistrasi.data.katalog_produk.length > 0
    ) {
      return (
        <Fragment>
          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <h3>Ketentuan Produk</h3>
              <div
                style={{
                  flex: 1,
                  height: '1px',
                  backgroundColor: 'white', // Set the color of the divider
                  margin: '0 10px' // Adjust margin as needed
                }}
              ></div>
            </div>
          </Grid>
          <table
            style={{
              width: '100%'
            }}
          >
            <tbody>
              {store.dataResponseRegistrasi.data.katalog_produk[0].policies.map((item, index) => (
                <tr key={`policies-${index}`}>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid white',
                      padding: '8px',
                      backgroundColor: 'white',
                      color: 'black',
                      fontSize: '10pt',
                      borderTopLeftRadius: '6px',
                      borderBottomLeftRadius: '6px'
                    }}
                  >
                    <div style={{ display: 'flex', alignItems: 'center' }}>
                      <Fab color='primary' aria-label='add' size='small' style={style_stepper_dot}>
                        {index + 1}
                      </Fab>
                      {item.policy.name}
                    </div>
                  </td>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid white',
                      padding: '8px',
                      backgroundColor: 'transparent',
                      fontSize: '10pt',
                      borderTopRightRadius: '6px',
                      borderBottomRightRadius: '6px'
                    }}
                  >
                    {item.description}
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
          <style jsx>{`
            @media (max-width: 600px) {
              /* Atur lebar kolom menjadi 100% pada tampilan mobile */
              table td {
                width: 100% !important;
                display: block;
                box-sizing: border-box;
              }
            }
          `}</style>
        </Fragment>
      )
    }
  }

  return (
    <Fragment>
      <div style={{ padding: '10px', marginLeft: '10px', minHeight: '500px', width: '100%', paddingBottom: '80px' }}>
        <div style={{ textAlign: 'center', marginBottom: '50px' }}>
          <h4>
            Terima kasih, proses registrasi Anda telah berhasil diajukan. Fitur dan Ketentuan produk layanan yang akan
            Anda dapatkan adalah sebagai berikut.
          </h4>
          <Typography style={styleText}></Typography>
        </div>
        <Grid container spacing={5}>
          {/* section 1 */}

          <Grid item xs={12} sm={6}>
            <table
              style={{
                width: '100%'
              }}
            >
              <tbody>
                <tr>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid #ADC52D',
                      padding: '8px',
                      backgroundColor: '#ADC52D',
                      fontSize: '10pt',
                      borderTopLeftRadius: '6px',
                      borderBottomLeftRadius: '6px'
                    }}
                  >
                    Nama Produk
                  </td>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid #ADC52D',
                      padding: '8px',
                      backgroundColor: 'transparent',
                      fontSize: '10pt',
                      borderTopRightRadius: '6px',
                      borderBottomRightRadius: '6px'
                    }}
                  >
                    {store.dataResponseRegistrasi &&
                    store.dataResponseRegistrasi.data &&
                    store.dataResponseRegistrasi.data.katalog_produk.length > 0
                      ? store.dataResponseRegistrasi.data.katalog_produk[0].name
                      : ''}
                  </td>
                </tr>
              </tbody>
            </table>
          </Grid>
          <Grid item xs={12} sm={6}>
            <table
              style={{
                width: '100%'
              }}
            >
              <tbody>
                <tr>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid #ADC52D',
                      padding: '8px',
                      backgroundColor: '#ADC52D',
                      fontSize: '10pt',
                      borderTopLeftRadius: '6px',
                      borderBottomLeftRadius: '6px'
                    }}
                  >
                    Kode CRM
                  </td>
                  <td
                    style={{
                      width: '50%',
                      border: '1px solid #ADC52D',
                      padding: '8px',
                      backgroundColor: 'transparent',
                      fontSize: '10pt',
                      borderTopRightRadius: '6px',
                      borderBottomRightRadius: '6px'
                    }}
                  >
                    {store.dataResponseRegistrasi &&
                    store.dataResponseRegistrasi.data &&
                    store.dataResponseRegistrasi.data.katalog_produk.length > 0
                      ? store.dataResponseRegistrasi.data.katalog_produk[0].code
                      : ''}
                  </td>
                </tr>
              </tbody>
            </table>
          </Grid>

          <Grid item xs={12} sm={12}>
            <FiturKomponen />

            <FiturKetentuan />
          </Grid>
        </Grid>
      </div>
    </Fragment>
  )
}

export default FormBerhasil
