// ** React Imports
import { forwardRef, useState, Fragment, useEffect } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Button from '@mui/material/Button'
import Divider from '@mui/material/Divider'
import Typography from '@mui/material/Typography'
import CircularProgress from '@mui/material/CircularProgress'
import CustomTextField from 'src/@core/components/mui/text-field'
import CustomAutocomplete from 'src/@core/components/mui/autocomplete'
import { styled } from '@mui/material/styles'
import MuiInputLabel from '@mui/material/InputLabel'
import DialogTitle from '@mui/material/DialogTitle'
import DialogContent from '@mui/material/DialogContent'
import DialogActions from '@mui/material/DialogActions'
import Dialog from '@mui/material/Dialog'
import DialogContentText from '@mui/material/DialogContentText'
import Chip from '@mui/material/Chip'

// ** CleaveJS Imports
import CleaveWrapper from 'src/@core/styles/libs/react-cleave'
import Cleave from 'cleave.js/react'
import 'cleave.js/dist/addons/cleave-phone.us'

import { useDispatch, useSelector } from 'react-redux'
import { setErrorApi, setLokasiPemasangan, setDataMap } from 'src/store/apps/register'

import { callGet } from 'src/service/api'
import { Endpoint } from 'src/service/constant'
import GoogleMaps from 'src/views/register/components/GoogleMaps'
import DigioMaps from 'src/views/register/components/DigioMaps'

const InputLabel = styled(MuiInputLabel)(({ theme }) => ({
  lineHeight: 1.154,
  maxWidth: 'max-content',
  marginBottom: theme.spacing(1),
  color: theme.palette.text.primary,
  fontSize: theme.typography.body2.fontSize
}))

const FormLokasiPemasangan = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  const setDefaultErrorState = () => {
    dispatch(
      setErrorApi({
        data: {},
        message: '',
        status: false
      })
    )
  }

  const [dataLokasiPemasangan, setDataLokasiPemasangan] = useState({
    provinsi: null,
    kota: null,
    kecamatan: null,
    kelurahan: null,
    select_perumahan_jalan_utama: null,
    nama_perumahan_jalan_utama: '',
    rt: '',
    rw: '',
    kode_pos: '',
    alamat: '',
    jenis_bangunan: null,
    status_lokasi_pemasangan: 0,
    status_kepemilikan: null,
    nama_pemilik_bangunan: '',
    no_telpon: '',
    latitude: -6.2088,
    longitude: 106.8456,
    maps: 1,
    tagging_map: false
  })

  useEffect(() => {
    setDataLokasiPemasangan(store.dataLokasiPemasangan)
    window.scrollTo({
      top: 0,
      behavior: 'smooth'
    })
  }, [])

  const setStateLocal = (key, value) => {
    if ((key == 'latitude' && value != -6.2088) || (key == 'longitude' && value != 106.8456)) {
      setDataLokasiPemasangan(prevState => ({
        ...prevState,
        [key]: value
      }))
    }

    if (key != 'latitude' && key != 'longitude') {
      setDataLokasiPemasangan(prevState => ({
        ...prevState,
        [key]: value
      }))
    }
  }

  useEffect(() => {
    dispatch(setLokasiPemasangan(dataLokasiPemasangan))
  }, [dataLokasiPemasangan])

  useEffect(() => {
    // console.log("store = ",store.dataLokasiPemasangan)
  }, [store.dataLokasiPemasangan])

  // ASYNC SELECT
  const [openProvinsi, setOpenProvinsi] = useState(false)
  const [optionsProvinsi, setOptionsProvinsi] = useState([])
  const [loadingProvinsi, setLoadingProvinsi] = useState(false)

  const [openKota, setOpenKota] = useState(false)
  const [optionsKota, setOptionsKota] = useState([])
  const [loadingKota, setLoadingKota] = useState(false)

  const [openKecamatan, setOpenKecamatan] = useState(false)
  const [optionsKecamatan, setOptionsKecamatan] = useState([])
  const [loadingKecamatan, setLoadingKecamatan] = useState(false)

  const [openKelurahan, setOpenKelurahan] = useState(false)
  const [optionsKelurahan, setOptionsKelurahan] = useState([])
  const [loadingKelurahan, setLoadingKelurahan] = useState(false)

  const [openPerumahan, setOpenPerumahan] = useState(false)
  const [optionsPerumahan, setOptionsPerumahan] = useState([])
  const [loadingPerumahan, setLoadingPerumahan] = useState(false)

  const [openJenisBangunan, setOpenJenisBangunan] = useState(false)
  const [optionsJenisBangunan, setOptionsJenisBangunan] = useState([])
  const [loadingJenisBangunan, setLoadingJenisBangunan] = useState(false)

  const [openStatusKepemilikan, setOpenStatusKepemilikan] = useState(false)
  const [optionsStatusKepemilikan, setOptionsStatusKepemilikan] = useState([])
  const [loadingStatusKepemilikan, setLoadingStatusKepemilikan] = useState(false)

  const [isDigioMapsLoaded, setIsDigioMapsLoaded] = useState(true)
  const [openPetunjukPenggunaanPeta, setOpenPetunjukPenggunaanPeta] = useState(false)

  const handleDigioMapsError = () => {
    setIsDigioMapsLoaded(false)
  }

  const handleClosePetunjukPenggunaanPeta = () => {
    setOpenPetunjukPenggunaanPeta(false)
  }

  useEffect(() => {
    dispatch(setDataMap(isDigioMapsLoaded))
  }, [isDigioMapsLoaded])

  useEffect(() => {
    let active = true
    if (!loadingProvinsi) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsProvinsi.length == 0) {
      fetchDataProvinsi(active)
    } else {
      setLoadingProvinsi(false)
    }

    return () => {
      active = false
    }
  }, [loadingProvinsi])

  useEffect(() => {
    let active = true
    if (!loadingKota) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsKota.length == 0) {
      fetchDataKota(active)
    } else {
      setLoadingKota(false)
    }

    return () => {
      active = false
    }
  }, [loadingKota])

  useEffect(() => {
    let active = true
    if (!loadingKecamatan) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsKecamatan.length == 0) {
      fetchDataKecamatan(active)
    } else {
      setLoadingKecamatan(false)
    }

    return () => {
      active = false
    }
  }, [loadingKecamatan])

  useEffect(() => {
    let active = true
    if (!loadingKelurahan) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsKelurahan.length == 0) {
      fetchDataKelurahan(active)
    } else {
      setLoadingKelurahan(false)
    }

    return () => {
      active = false
    }
  }, [loadingKelurahan])

  useEffect(() => {
    let active = true
    if (!loadingPerumahan) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsPerumahan.length == 0) {
      fetchDataPerumahan(active)
    } else {
      setLoadingPerumahan(false)
    }

    return () => {
      active = false
    }
  }, [loadingPerumahan])

  useEffect(() => {
    let active = true
    if (!loadingJenisBangunan) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsJenisBangunan.length == 0) {
      fetchDataJenisBangunan(active)
    } else {
      setLoadingJenisBangunan(false)
    }

    return () => {
      active = false
    }
  }, [loadingJenisBangunan])

  useEffect(() => {
    let active = true
    if (!loadingStatusKepemilikan) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsStatusKepemilikan.length == 0) {
      fetchDataStatusKepemilikan(active)
    } else {
      setLoadingStatusKepemilikan(false)
    }

    return () => {
      active = false
    }
  }, [loadingStatusKepemilikan])

  const fetchDataProvinsi = async active => {
    const responseProvinsi = await callGet(Endpoint.getListProvince)

    if (!responseProvinsi.status) {
      dispatch(
        setErrorApi({
          data: responseProvinsi.data,
          message: responseProvinsi.message,
          status: true
        })
      )
    } else {
      if (active) {
        setOptionsProvinsi(responseProvinsi.data.data)
      }
    }

    setLoadingProvinsi(false)
  }

  const fetchDataKota = async active => {
    if (dataLokasiPemasangan.provinsi != null) {
      let params = {
        geo_province_id: dataLokasiPemasangan.provinsi.id
      }

      const responseKota = await callGet(Endpoint.getListTown, params)

      if (!responseKota.status) {
        dispatch(
          setErrorApi({
            data: responseKota.data,
            message: responseKota.message,
            status: true
          })
        )
      } else {
        if (active) {
          setOptionsKota(responseKota.data.data)
        }
      }
    }
    setLoadingKota(false)
  }

  const fetchDataKecamatan = async active => {
    if (dataLokasiPemasangan.kota != null) {
      let params = {
        geo_town_id: dataLokasiPemasangan.kota.id
      }
      const responseKecamatan = await callGet(Endpoint.getListDistrict, params)

      if (!responseKecamatan.status) {
        dispatch(
          setErrorApi({
            data: responseKecamatan.data,
            message: responseKecamatan.message,
            status: true
          })
        )
      } else {
        if (active) {
          setOptionsKecamatan(responseKecamatan.data.data)
        }
      }
    }
    setLoadingKecamatan(false)
  }

  const fetchDataKelurahan = async active => {
    if (dataLokasiPemasangan.kecamatan != null) {
      let params = {
        geo_district_id: dataLokasiPemasangan.kecamatan.id
      }

      const responseKelurahan = await callGet(Endpoint.getListVillage, params)

      if (!responseKelurahan.status) {
        dispatch(
          setErrorApi({
            data: responseKelurahan.data,
            message: responseKelurahan.message,
            status: true
          })
        )
      } else {
        if (active) {
          setOptionsKelurahan(responseKelurahan.data.data)
        }
      }
    }
    setLoadingKelurahan(false)
  }

  const fetchDataPerumahan = async active => {
    if (dataLokasiPemasangan.kelurahan != null) {
      let params = {
        geo_province_id: dataLokasiPemasangan.provinsi.id,
        geo_town_id: dataLokasiPemasangan.kota.id,
        geo_district_id: dataLokasiPemasangan.kecamatan.id,
        geo_village_id: dataLokasiPemasangan.kelurahan.id
      }
      const responsePerumahan = await callGet(Endpoint.getListHousingArea, params)

      if (!responsePerumahan.status) {
        dispatch(
          setErrorApi({
            data: responsePerumahan.data,
            message: responsePerumahan.message,
            status: true
          })
        )
      } else {
        if (active) {
          setOptionsPerumahan(responsePerumahan.data.data)
        }
      }
    }
    setLoadingPerumahan(false)
  }

  const fetchDataJenisBangunan = async active => {
    const responseJenisBangunan = await callGet(Endpoint.getListBuildingType)

    if (!responseJenisBangunan.status) {
      dispatch(
        setErrorApi({
          data: responseJenisBangunan.data,
          message: responseJenisBangunan.message,
          status: true
        })
      )
    } else {
      if (active) {
        let temp_data = []
        if (store.dataKebutuhan == '1') {
          temp_data = responseJenisBangunan.data.data.filter(item => item.id == 2 || item.id == 3)
        } else if (store.dataKebutuhan == '2') {
          temp_data = responseJenisBangunan.data.data.filter(item => item.id != 2 && item.id != 3)
        }
        setOptionsJenisBangunan(temp_data)
      }
    }

    setLoadingJenisBangunan(false)
  }

  const fetchDataStatusKepemilikan = async active => {
    const responseStatusKepemilikan = await callGet(Endpoint.getListStatusLocation)

    if (!responseStatusKepemilikan.status) {
      dispatch(
        setErrorApi({
          data: responseStatusKepemilikan.data,
          message: responseStatusKepemilikan.message,
          status: true
        })
      )
    } else {
      if (active) {
        setOptionsStatusKepemilikan(responseStatusKepemilikan.data.data)
      }
    }

    setLoadingJenisBangunan(false)
  }

  const handleSelectProvinsi = (event, newValue) => {
    setOptionsKota([])
    setOptionsKecamatan([])
    setOptionsKelurahan([])
    setOptionsPerumahan([])

    setStateLocal('provinsi', newValue)
  }

  const handleSelectKota = (event, newValue) => {
    setOptionsKecamatan([])
    setOptionsKelurahan([])
    setOptionsPerumahan([])

    setStateLocal('kota', newValue)
  }

  const handleSelectKecamatan = (event, newValue) => {
    setOptionsKelurahan([])
    setOptionsPerumahan([])

    setStateLocal('kecamatan', newValue)
  }

  const handleSelectKelurahan = (event, newValue) => {
    setOptionsPerumahan([])

    setStateLocal('kelurahan', newValue)
  }

  const handleSelectPerumahan = (event, newValue) => {
    setStateLocal('select_perumahan_jalan_utama', newValue)
  }

  const handleSelectJenisBangunan = (event, newValue) => {
    setStateLocal('jenis_bangunan', newValue)
  }

  const handleSelectStatusKepemilikan = (event, newValue) => {
    setStateLocal('status_kepemilikan', newValue)
  }

  const handleUseMyLocation = () => {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(
        position => {
          const { latitude, longitude } = position.coords

          setStateLocal('latitude', latitude)
          setStateLocal('longitude', longitude)
        },
        error => {
          console.error('Error getting location:', error.message)
        }
      )
    } else {
      console.error('Geolocation is not supported by this browser.')
    }
  }

  const handlePetunjukPenggunaanPeta = () => {
    setOpenPetunjukPenggunaanPeta(true)
  }

  const DialogPetunjukPenggunaanPeta = () => {
    return (
      <Fragment>
        <Dialog
          open={openPetunjukPenggunaanPeta}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleClosePetunjukPenggunaanPeta()
            }
          }}
        >
          <Grid container spacing={5} style={{ userSelect: 'none' }}>
            <Grid item xs={12} sm={12}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Petunjuk Penggunaan Peta
              </DialogTitle>
              <DialogContent dividers={true}>
                <ul style={{ listStyle: 'none', padding: 0 }}>
                  <li style={{ marginBottom: '10px' }}>
                    <div style={{ display: 'flex', alignItems: 'center' }}>
                      <div style={{ alignSelf: 'flex-start' }}>
                        <Chip label='1' color='success' style={{ width: '33px' }} />
                      </div>
                      <div style={{ marginLeft: '10px' }}>Ketik alamat Anda di kotak pencarian.</div>
                    </div>
                  </li>
                  <li style={{ marginBottom: '10px' }}>
                    <div style={{ display: 'flex', alignItems: 'center' }}>
                      <div style={{ alignSelf: 'flex-start' }}>
                        <Chip label='2' color='success' style={{ width: '33px' }} />
                      </div>
                      <div style={{ marginLeft: '10px' }}>
                        Arahkan dan tandai kotak warna hitam sesuai dengan lokasi Anda sampai kotak berubah warna
                        menjadi <b>HIJAU</b>.
                      </div>
                    </div>
                  </li>
                  <li style={{ marginBottom: '10px' }}>
                    <div style={{ display: 'flex', alignItems: 'center' }}>
                      <div style={{ alignSelf: 'flex-start' }}>
                        <Chip label='3' color='success' style={{ width: '33px' }} />
                      </div>
                      <div style={{ marginLeft: '10px' }}>
                        Apabila lokasi Anda belum tersedia Kotak <b>HITAM</b> yang Anda inginkan di peta atau termasuk
                        bangunan <b>BARU</b>, klik Tanda Plus (+), kemudian arahkan ke lokasi baru untuk menambah Kotak
                        hitam, kemudian klik Tanda Plus (+) lagi dan tandai Kotak <b>HITAM</b> agar menjadi Kotak{' '}
                        <b>HIJAU</b>.
                      </div>
                    </div>
                  </li>
                  <li></li>
                </ul>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={() => setOpenPetunjukPenggunaanPeta(false)}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Lanjutkan
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const styleText = {
    color: 'white'
  }

  return (
    <Fragment>
      <div style={{ padding: '10px', marginLeft: '10px', minHeight: '500px', width: '100%', paddingBottom: '80px' }}>
        <div style={{ textAlign: 'center' }}>
          <h1>Lokasi Pemasangan</h1>
          <Typography style={styleText}></Typography>
        </div>
        <Grid container spacing={5}>
          {/* SECTION 1 */}

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.provinsi}
              open={openProvinsi}
              options={optionsProvinsi}
              loading={loadingProvinsi}
              onOpen={() => {
                setOpenProvinsi(true)
                setLoadingProvinsi(true)
              }}
              onClose={() => {
                setOpenProvinsi(false)
                setLoadingProvinsi(false)
              }}
              onChange={handleSelectProvinsi}
              id='select-provinsi'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Provinsi *'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingProvinsi ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Pilih Provinsi'
                />
              )}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.kota}
              open={openKota}
              options={optionsKota}
              loading={loadingKota}
              onOpen={() => {
                setOpenKota(true)
                setLoadingKota(true)
              }}
              onClose={() => {
                setOpenKota(false)
                setLoadingKota(false)
              }}
              onChange={handleSelectKota}
              id='select-kota'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Kota/Kabupaten *'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingKota ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Pilih Kota/Kabupaten'
                />
              )}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.kecamatan}
              open={openKecamatan}
              options={optionsKecamatan}
              loading={loadingKecamatan}
              onOpen={() => {
                setOpenKecamatan(true)
                setLoadingKecamatan(true)
              }}
              onClose={() => {
                setOpenKecamatan(false)
                setLoadingKecamatan(false)
              }}
              onChange={handleSelectKecamatan}
              id='select-kecamatan'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Kecamatan *'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingKecamatan ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Pilih Kecamatan'
                />
              )}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.kelurahan}
              open={openKelurahan}
              options={optionsKelurahan}
              loading={loadingKelurahan}
              onOpen={() => {
                setOpenKelurahan(true)
                setLoadingKelurahan(true)
              }}
              onClose={() => {
                setOpenKelurahan(false)
                setLoadingKelurahan(false)
              }}
              onChange={handleSelectKelurahan}
              id='select-kelurahan'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Kelurahan *'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingKelurahan ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Pilih Kelurahan'
                />
              )}
            />
          </Grid>

          <Grid item xs={12}>
            <Divider sx={{ mb: '0 !important' }} style={{ backgroundColor: 'white' }} />
          </Grid>

          {/* SECTION 2 */}

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.select_perumahan_jalan_utama}
              open={openPerumahan}
              options={optionsPerumahan}
              loading={loadingPerumahan}
              onOpen={() => {
                setOpenPerumahan(true)
                setLoadingPerumahan(true)
              }}
              onClose={() => {
                setOpenPerumahan(false)
                setLoadingPerumahan(false)
              }}
              onChange={handleSelectPerumahan}
              id='select-perumahan'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Perumahan/Jalan Utama'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingPerumahan ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Pilih Perumahan/Jalan Utama'
                />
              )}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <span style={{ fontSize: '10pt' }}>
              Silakan pilih Perumahan/Jalan Utama sesuai lokasi pemasangan Gas yang ingin Anda daftarkan. Apabila tidak
              menemukan nama Perumahan/Jalan Utama yang Anda inginkan, agar mengisi di bagian Perumahan/Jalan Utama
              Lainnya.
            </span>
          </Grid>

          <Grid item xs={12} sm={12}>
            <CustomTextField
              fullWidth
              label='Nama Perumahan/Jalan Utama Lainnya'
              placeholder='Nama Perumahan/Jalan Utama Lainnya'
              value={dataLokasiPemasangan.nama_perumahan_jalan_utama}
              onChange={e => setStateLocal('nama_perumahan_jalan_utama', e.target.value)}
            />
          </Grid>

          <Grid item xs={12} sm={4}>
            <CleaveWrapper>
              <InputLabel htmlFor='rt' style={{ color: 'white' }}>
                RT
              </InputLabel>
              <Cleave
                id='rt'
                options={{ blocks: [3], numericOnly: true }}
                style={{ backgroundColor: 'white' }}
                placeholder='RT'
                value={dataLokasiPemasangan.rt}
                onChange={e => setStateLocal('rt', e.target.value)}
              />
            </CleaveWrapper>
          </Grid>

          <Grid item xs={12} sm={4}>
            <CleaveWrapper>
              <InputLabel htmlFor='rw' style={{ color: 'white' }}>
                RW
              </InputLabel>
              <Cleave
                id='rw'
                options={{ blocks: [3], numericOnly: true }}
                style={{ backgroundColor: 'white' }}
                placeholder='RW'
                value={dataLokasiPemasangan.rw}
                onChange={e => setStateLocal('rw', e.target.value)}
              />
            </CleaveWrapper>
          </Grid>

          <Grid item xs={12} sm={4}>
            <CleaveWrapper>
              <InputLabel htmlFor='kode_pos' style={{ color: 'white' }}>
                Kode Pos
              </InputLabel>
              <Cleave
                id='kode_pos'
                options={{ blocks: [5], numericOnly: true }}
                style={{ backgroundColor: 'white' }}
                placeholder='Kode Pos'
                value={dataLokasiPemasangan.kode_pos}
                onChange={e => setStateLocal('kode_pos', e.target.value)}
              />
            </CleaveWrapper>
          </Grid>

          <Grid item xs={12} sm={12}>
            <span style={{ fontSize: '10pt' }}>*Apabila Alamat Anda tidak ada RT RW, silakan isi dengan angka NOL</span>
          </Grid>

          <Grid item xs={12} sm={12}>
            <CustomTextField
              fullWidth
              label='Alamat Lengkap Lokasi Pemasangan *'
              placeholder='Alamat Lengkap Lokasi Pemasangan'
              value={dataLokasiPemasangan.alamat}
              onChange={e => setStateLocal('alamat', e.target.value)}
            />
          </Grid>

          <Grid item xs={12}>
            <Divider sx={{ mb: '0 !important' }} style={{ backgroundColor: 'white' }} />
          </Grid>

          {/* SECTION 3 */}

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.jenis_bangunan}
              open={openJenisBangunan}
              options={optionsJenisBangunan}
              loading={loadingJenisBangunan}
              onOpen={() => {
                setOpenJenisBangunan(true)
                setLoadingJenisBangunan(true)
              }}
              onClose={() => {
                setOpenJenisBangunan(false)
                setLoadingJenisBangunan(false)
              }}
              onChange={handleSelectJenisBangunan}
              id='select-jenis-bangunan'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Jenis Bangunan *'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingJenisBangunan ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Pilih Jenis Bangunan'
                />
              )}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <span style={{ fontSize: '9.5pt' }}>Status Lokasi Pemasangan</span>
            <br />
            <Grid container spacing={5}>
              {dataLokasiPemasangan.status_lokasi_pemasangan == 0 && (
                <Fragment>
                  <Grid item xs={6} sm={6}>
                    <Button
                      variant='contained'
                      color='success'
                      size='medium'
                      fullWidth
                      onClick={() => {
                        setStateLocal('status_lokasi_pemasangan', 0)
                      }}
                    >
                      <span style={{ fontSize: '10pt' }}>Milik Pribadi</span>
                    </Button>
                  </Grid>
                  <Grid item xs={6} sm={6}>
                    <Button
                      variant='contained'
                      color='secondary'
                      size='medium'
                      fullWidth
                      onClick={() => {
                        setStateLocal('status_lokasi_pemasangan', 1)
                      }}
                    >
                      <span style={{ fontSize: '10pt', color: '#000' }}>Milik Pemerintah</span>
                    </Button>
                  </Grid>
                </Fragment>
              )}

              {dataLokasiPemasangan.status_lokasi_pemasangan == 1 && (
                <Fragment>
                  <Grid item xs={6} sm={6}>
                    <Button
                      variant='contained'
                      color='secondary'
                      size='medium'
                      fullWidth
                      onClick={() => {
                        setStateLocal('status_lokasi_pemasangan', 0)
                      }}
                    >
                      <span style={{ fontSize: '9pt', color: '#000' }}>Milik Pribadi</span>
                    </Button>
                  </Grid>
                  <Grid item xs={6} sm={6}>
                    <Button
                      variant='contained'
                      color='success'
                      size='medium'
                      fullWidth
                      onClick={() => {
                        setStateLocal('status_lokasi_pemasangan', 1)
                      }}
                    >
                      <span style={{ fontSize: '9pt' }}>Milik Pemerintah</span>
                    </Button>
                  </Grid>
                </Fragment>
              )}
            </Grid>
          </Grid>

          {/* MAP */}
          <Grid item xs={12} sm={12}>
            <InputLabel htmlFor='map' style={{ color: 'white' }}>
              Peta Lokasi
            </InputLabel>

            {isDigioMapsLoaded ? (
              <div>
                <DigioMaps
                  latitude={store.dataLokasiPemasangan.latitude}
                  longitude={store.dataLokasiPemasangan.longitude}
                  dataLokasiPemasangan={dataLokasiPemasangan}
                  setStateLocal={setStateLocal}
                  onError={handleDigioMapsError}
                />

                <Grid container spacing={5}>
                  <Grid item xs={12} sm={6}>
                    <span style={{ fontSize: '10pt' }}>
                      Pastikan <b>koordinat</b> lokasi berlangganan gas Anda sudah <b>tepat dan benar</b>, sehingga
                      pemasangan pipa gas dan pencatatan Meter sesuai lokasi yang Anda daftarkan.
                    </span>
                  </Grid>

                  <Grid item xs={12} sm={6}>
                    <div style={{ display: 'flex', justifyContent: 'end', alignItems: 'baseline', marginTop: '10px' }}>
                      <div>
                        <Button
                          variant='contained'
                          color='success'
                          size='medium'
                          fullWidth
                          onClick={() => {
                            handlePetunjukPenggunaanPeta()
                          }}
                        >
                          <span style={{ fontSize: '10pt' }}>Petunjuk Penggunaan Peta</span>
                        </Button>
                      </div>
                    </div>
                  </Grid>
                </Grid>
              </div>
            ) : (
              <div>
                <GoogleMaps
                  latitude={store.dataLokasiPemasangan.latitude}
                  longitude={store.dataLokasiPemasangan.longitude}
                  dataLokasiPemasangan={dataLokasiPemasangan}
                  setStateLocal={setStateLocal}
                />

                <Grid container spacing={5}>
                  <Grid item xs={12} sm={6}>
                    <span style={{ fontSize: '10pt' }}>
                      Pastikan <b>koordinat</b> lokasi berlangganan gas Anda sudah <b>tepat dan benar</b>, sehingga
                      pemasangan pipa gas dan pencatatan Meter sesuai lokasi yang Anda daftarkan.
                    </span>
                  </Grid>

                  <Grid item xs={12} sm={6}>
                    <div style={{ display: 'flex', justifyContent: 'end', alignItems: 'baseline', marginTop: '10px' }}>
                      <div>
                        <Button
                          variant='contained'
                          color='success'
                          size='medium'
                          fullWidth
                          onClick={() => {
                            handleUseMyLocation()
                          }}
                        >
                          <span style={{ fontSize: '10pt' }}>Lokasi Saya Saat Ini</span>
                        </Button>
                      </div>
                    </div>
                  </Grid>
                </Grid>
              </div>
            )}
          </Grid>

          <Grid item xs={12}>
            <Divider sx={{ mb: '0 !important' }} style={{ backgroundColor: 'white' }} />
          </Grid>

          {/* SECTION 3 */}

          <Grid item xs={12} sm={6}>
            <CustomAutocomplete
              value={dataLokasiPemasangan.status_kepemilikan}
              open={openStatusKepemilikan}
              options={optionsStatusKepemilikan}
              loading={loadingStatusKepemilikan}
              onOpen={() => {
                setOpenStatusKepemilikan(true)
                setLoadingStatusKepemilikan(true)
              }}
              onClose={() => {
                setOpenStatusKepemilikan(false)
                setLoadingStatusKepemilikan(false)
              }}
              onChange={handleSelectStatusKepemilikan}
              id='select-status-kepemilikan'
              getOptionLabel={option => option.name || ''}
              isOptionEqualToValue={(option, value) => option.name === value.name}
              renderInput={params => (
                <CustomTextField
                  {...params}
                  label='Status Kepemilikan *'
                  InputProps={{
                    ...params.InputProps,
                    endAdornment: (
                      <Fragment>
                        {loadingStatusKepemilikan ? <CircularProgress size={20} /> : null}
                        {params.InputProps.endAdornment}
                      </Fragment>
                    )
                  }}
                  placeholder='Status Kepemilikan'
                />
              )}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <span style={{ fontSize: '10pt' }}>
              Apabila status kepemilikan bangunan dimiliki oleh orang lain, pastikan anda sudah mendapatkan persetujuan
              pemasangan pipa gas dari pemilik bangunan.
            </span>
          </Grid>

          {dataLokasiPemasangan.status_kepemilikan && dataLokasiPemasangan.status_kepemilikan.id == 2 ? (
            <Fragment>
              <Grid item xs={12} sm={6}>
                <CustomTextField
                  fullWidth
                  label='Nama Pemilik Bangunan *'
                  placeholder='Nama Pemilik Bangunan'
                  value={dataLokasiPemasangan.nama_pemilik_bangunan}
                  onChange={e => setStateLocal('nama_pemilik_bangunan', e.target.value)}
                />
              </Grid>

              <Grid item xs={12} sm={6}>
                <CleaveWrapper>
                  <InputLabel htmlFor='no-telp-pemilik-bangunan' style={{ color: 'white' }}>
                    No Telpon/HP Pemilik Bangunan *
                  </InputLabel>
                  <Cleave
                    id='no-telp-pemilik-bangunan'
                    options={{ prefix: '+62', blocks: [3, 3, 4, 4], numericOnly: true }}
                    style={{ backgroundColor: 'white' }}
                    placeholder='000 0000 0000'
                    value={dataLokasiPemasangan.no_telpon}
                    onChange={e => setStateLocal('no_telpon', e.target.value)}
                  />
                </CleaveWrapper>
              </Grid>
            </Fragment>
          ) : (
            ''
          )}
        </Grid>
        <Divider sx={{ m: '0 !important' }} />

        {/* DIALOG */}
        <DialogPetunjukPenggunaanPeta />
      </div>
    </Fragment>
  )
}

export default FormLokasiPemasangan
