// ** React Imports
import React, { forwardRef, useState, Fragment, useEffect } from 'react'

// ** MUI Imports
import Card from '@mui/material/Card'
import Grid from '@mui/material/Grid'
import Divider from '@mui/material/Divider'
import Typography from '@mui/material/Typography'
import CardContent from '@mui/material/CardContent'
import CircularProgress from '@mui/material/CircularProgress'
import CustomTextField from 'src/@core/components/mui/text-field'
import TextFieldAlat from 'src/@core/components/mui/text-field/textFieldAlat'
import CustomAutocomplete from 'src/@core/components/mui/autocomplete'
import Box from '@mui/material/Box'
import { styled } from '@mui/material/styles'
import MuiInputLabel from '@mui/material/InputLabel'
import CustomTimelineDot from 'src/@core/components/mui/timeline-dot'
import toast from 'react-hot-toast'
import Button from '@mui/material/Button'

import Dialog from '@mui/material/Dialog'
import DialogTitle from '@mui/material/DialogTitle'
import DialogContent from '@mui/material/DialogContent'
import DialogActions from '@mui/material/DialogActions'
import DialogContentText from '@mui/material/DialogContentText'

// ** CleaveJS Imports
import CleaveWrapper from 'src/@core/styles/libs/react-cleave'
import Cleave from 'cleave.js/react'
import 'cleave.js/dist/addons/cleave-phone.us'

// ** Icon Imports
import Icon from 'src/@core/components/icon'
import heroPackagePGN from 'public/images/pgn/pgn_hero_package.png'

import { useDispatch, useSelector } from 'react-redux'
import { setErrorApi, setPenggunaan } from 'src/store/apps/register'

import { callGet, callPost } from 'src/service/api'
import { Endpoint } from 'src/service/constant'

const InputLabel = styled(MuiInputLabel)(({ theme }) => ({
  lineHeight: 1.154,
  maxWidth: 'max-content',
  marginBottom: theme.spacing(1),
  color: theme.palette.text.primary,
  fontSize: theme.typography.body2.fontSize
}))

const VisuallyHiddenInput = styled('input')({
  clip: 'rect(0 0 0 0)',
  clipPath: 'inset(50%)',
  height: 1,
  overflow: 'hidden',
  position: 'absolute',
  bottom: 0,
  left: 0,
  whiteSpace: 'nowrap',
  width: 1
})

const FormLokasiPemasangan = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  const setDefaultErrorState = () => {
    dispatch(
      setErrorApi({
        data: {},
        message: '',
        status: false
      })
    )
  }

  const [dataPenggunaan, setDataPenggunaan] = useState({
    nama: '',
    ktp: '',
    no_telpon: '',
    email: '',
    ktp_file: null,
    energi_listrik: null,
    rekening_listrik_file: null,
    bahan_bakar: [],
    peralatan: []
  })

  const setStateLocal = (key, value) => {
    setDataPenggunaan(prevState => ({
      ...prevState,
      [key]: value
    }))
  }

  const [openDuplicate, setOpenDuplicate] = useState(false)
  const handleCloseDuplicate = () => setOpenDuplicate(false)
  const [dataDuplicate, setDataDuplicate] = useState([])

  // ASYNC SELECT
  const [openPenggunaanEnergi, setOpenPenggunaanEnergi] = useState(false)
  const [optionsPenggunaanEnergi, setOptionsPenggunaanEnergi] = useState([])
  const [loadingPenggunaanEnergi, setLoadingPenggunaanEnergi] = useState(false)

  useEffect(() => {
    let active = true
    if (!loadingPenggunaanEnergi) {
      return undefined
    }

    setDefaultErrorState()

    if (optionsPenggunaanEnergi.length == 0) {
      fetchDataPenggunaanEnergi(active)
    } else {
      setLoadingPenggunaanEnergi(false)
    }

    return () => {
      active = false
    }
  }, [loadingPenggunaanEnergi])

  const fetchDataPenggunaanEnergi = async active => {
    const responsePenggunaanEnergi = await callGet(Endpoint.getListElectricalPower)

    if (!responsePenggunaanEnergi.status) {
      dispatch(
        setErrorApi({
          data: responsePenggunaanEnergi.data,
          message: responsePenggunaanEnergi.message,
          status: true
        })
      )
    } else {
      if (active) {
        setOptionsPenggunaanEnergi(responsePenggunaanEnergi.data.data)
      }
    }

    setLoadingPenggunaanEnergi(false)
  }

  const handleSelectPenggunaanEnergi = (event, newValue) => {
    setStateLocal('energi_listrik', newValue)
  }

  // END ASYNC SELECT

  const styleText = {
    color: 'white'
  }

  // BAHAN BAKAR

  useEffect(() => {
    dispatch(setPenggunaan(dataPenggunaan))
  }, [dataPenggunaan])

  useEffect(() => {
    setDataPenggunaan(store.dataPenggunaan)
    setDefaultErrorState()

    if (store.dataPenggunaan.bahan_bakar.length == 0) {
      fetchDataBahanBakar()
    }
    if (store.dataPenggunaan.peralatan.length == 0) {
      fetchDataPeralatan()
    }

    window.scrollTo({
      top: 0,
      behavior: 'smooth'
    })
  }, [])

  const fetchDataBahanBakar = async () => {
    const responseBahanBakar = await callGet(Endpoint.getListFuels)

    if (!responseBahanBakar.status) {
      dispatch(
        setErrorApi({
          data: responseBahanBakar.data,
          message: responseBahanBakar.message,
          status: true
        })
      )
    } else {
      const updatedData = responseBahanBakar.data.data.map(item => ({
        ...item,
        value: '',
        backgroundColor: 'transparent'
      }))
      setStateLocal('bahan_bakar', updatedData)
    }
  }

  const fetchDataPeralatan = async () => {
    const responsePeralatan = await callGet(Endpoint.getListGasTools)

    if (!responsePeralatan.status) {
      dispatch(
        setErrorApi({
          data: responsePeralatan.data,
          message: responsePeralatan.message,
          status: true
        })
      )
    } else {
      const updatedData = responsePeralatan.data.data.map(item => ({
        ...item,
        value: '',
        backgroundColor: 'transparent'
      }))
      setStateLocal('peralatan', updatedData)
    }
  }

  const BahanBakarItem = React.memo(({ bahan_bakar, handleClickButtonBahanBakar }) => {
    const items = bahan_bakar.map(data => (
      <Grid key={`bahan_bakar-${data.id}`} item xs={6} sm={3}>
        <Card
          sx={{
            height: '220px',
            backgroundColor: data.backgroundColor,
            border: '1px solid white',
            textAlign: 'center'
          }}
        >
          <CardContent style={{ paddingLeft: '0', paddingRight: '0' }}>
            <Typography sx={{ color: 'white', fontSize: '10pt' }}>{data.name}</Typography>
            <img src={data.full_icon_url} alt='' style={{ height: '100px' }}></img>

            <Box sx={{ display: 'inline-flex', width: '100%' }}>
              <Grid container spacing={0} alignItems='center'>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                  <CustomTimelineDot
                    className='minus-btn'
                    style={{
                      color: 'black',
                      borderColor: '#e4e2e2',
                      width: '24px',
                      display: 'flex',
                      alignItems: 'center',
                      justifyContent: 'center'
                    }}
                    onClick={() => handleClickButtonBahanBakar('minus', data)}
                  >
                    <Icon icon='tabler:minus' fontSize={12} />
                  </CustomTimelineDot>
                </Grid>
                <Grid item xs={6}>
                  <TextFieldAlat
                    size='small'
                    id='input-with-icon-grid'
                    placeholder='0'
                    InputProps={{ readOnly: true }}
                    value={data.value}
                  />
                </Grid>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                  <CustomTimelineDot
                    className='plus-btn'
                    style={{
                      color: 'black',
                      borderColor: '#e4e2e2',
                      width: '24px',
                      display: 'flex',
                      alignItems: 'center',
                      justifyContent: 'center'
                    }}
                    onClick={() => handleClickButtonBahanBakar('plus', data)}
                  >
                    <Icon icon='tabler:plus' fontSize={12} />
                  </CustomTimelineDot>
                </Grid>
              </Grid>
            </Box>
          </CardContent>
        </Card>
      </Grid>
    ))

    return <Fragment>{items}</Fragment>
  })

  const PeralatanItem = React.memo(({ peralatan, handleClickButtonPeralatan }) => {
    const items = peralatan.map(data => (
      <Grid key={`peralatan-${data.id}`} item xs={6} sm={3}>
        <Card
          sx={{
            height: '220px',
            backgroundColor: data.backgroundColor,
            border: '1px solid white',
            textAlign: 'center'
          }}
        >
          <CardContent style={{ paddingLeft: '0', paddingRight: '0' }}>
            <Typography sx={{ color: 'white', fontSize: '10pt' }}>{data.name}</Typography>
            <img src={data.full_icon_url} alt='' style={{ height: '100px' }}></img>

            <Box sx={{ display: 'inline-flex', width: '100%' }}>
              <Grid container spacing={0} alignItems='center'>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                  <CustomTimelineDot
                    className='minus-btn'
                    style={{
                      color: 'black',
                      borderColor: '#e4e2e2',
                      width: '24px',
                      display: 'flex',
                      alignItems: 'center',
                      justifyContent: 'center'
                    }}
                    onClick={() => handleClickButtonPeralatan('minus', data)}
                  >
                    <Icon icon='tabler:minus' fontSize={12} />
                  </CustomTimelineDot>
                </Grid>
                <Grid item xs={6}>
                  <TextFieldAlat
                    size='small'
                    id='input-with-icon-grid'
                    placeholder='0'
                    InputProps={{ readOnly: true }}
                    value={data.value}
                  />
                </Grid>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
                  <CustomTimelineDot
                    className='plus-btn'
                    style={{
                      color: 'black',
                      borderColor: '#e4e2e2',
                      width: '24px',
                      display: 'flex',
                      alignItems: 'center',
                      justifyContent: 'center'
                    }}
                    onClick={() => handleClickButtonPeralatan('plus', data)}
                  >
                    <Icon icon='tabler:plus' fontSize={12} />
                  </CustomTimelineDot>
                </Grid>
              </Grid>
            </Box>
          </CardContent>
        </Card>
      </Grid>
    ))

    return <Fragment>{items}</Fragment>
  })

  const handleClickButtonBahanBakar = (action, row) => {
    let temp_row = { ...row }

    switch (action) {
      case 'minus':
        if (temp_row.value != '' && parseInt(temp_row.value) > 0) {
          temp_row.value = parseInt(temp_row.value) - 1
          if (parseInt(temp_row.value) == 0) {
            temp_row.value = ''
          }
        } else {
          temp_row.value = ''
        }
        break

      case 'plus':
        if (temp_row.value == '' || parseInt(temp_row.value) == 0) {
          temp_row.value = 1
        } else if (temp_row.value != '' && parseInt(temp_row.value) > 0) {
          temp_row.value = parseInt(temp_row.value) + 1
        } else {
          temp_row.value = ''
        }
        break
    }

    if (temp_row.value == '') {
      temp_row.backgroundColor = 'transparent'
    } else {
      temp_row.backgroundColor = '#ADC52D'
    }

    const updatedBahanBakar = dataPenggunaan.bahan_bakar.map((item, index) => {
      if (item.id === temp_row.id) {
        return temp_row
      }

      return item
    })

    setStateLocal('bahan_bakar', updatedBahanBakar)
  }

  const handleClickButtonPeralatan = (action, row) => {
    let temp_row = { ...row }

    switch (action) {
      case 'minus':
        if (temp_row.value != '' && parseInt(temp_row.value) > 0) {
          temp_row.value = parseInt(temp_row.value) - 1
          if (parseInt(temp_row.value) == 0) {
            temp_row.value = ''
          }
        } else {
          temp_row.value = ''
        }
        break

      case 'plus':
        if (temp_row.value == '' || parseInt(temp_row.value) == 0) {
          temp_row.value = 1
        } else if (temp_row.value != '' && parseInt(temp_row.value) > 0) {
          temp_row.value = parseInt(temp_row.value) + 1
        } else {
          temp_row.value = ''
        }
        break
    }

    if (temp_row.value == '') {
      temp_row.backgroundColor = 'transparent'
    } else {
      temp_row.backgroundColor = '#ADC52D'
    }

    const updatedPeralatan = dataPenggunaan.peralatan.map((item, index) => {
      if (item.id === temp_row.id) {
        return temp_row
      }

      return item
    })

    setStateLocal('peralatan', updatedPeralatan)
  }

  const handleFileChange = (e, action) => {
    const selectedFile = e.target.files[0]

    if (selectedFile) {
      const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png']
      if (!allowedTypes.includes(selectedFile.type)) {
        toast.error('Tipe file yang diperbolehkan hanya berupa Gambar (jpg, jpeg, png).')

        return false
      }

      const maxSizeInBytes = 5 * 1024 * 1024 // 5 MB
      if (selectedFile.size > maxSizeInBytes) {
        toast.error('Ukuran file yang diperbolehkan maksimum 5 MB')

        return false
      }

      setStateLocal(action, selectedFile)
    } else {
      setStateLocal(action, null)
    }
  }

  const checkDuplicateData = async () => {
    setOpenDuplicate(false)
    setDataDuplicate([])

    let payload = {}

    if (dataPenggunaan.ktp != '') {
      payload.ktp = dataPenggunaan.ktp
    }
    if (
      dataPenggunaan.no_telpon.replaceAll(' ', '').replaceAll('+', '') != '' &&
      dataPenggunaan.no_telpon.replaceAll(' ', '').replaceAll('+', '') != '62'
    ) {
      payload.no_telpon = dataPenggunaan.no_telpon.replaceAll(' ', '').replaceAll('+', '')
    }

    const responseSubmit = await callPost(Endpoint.postCheckDuplicateData, payload)

    if (!responseSubmit.status) {
      dispatch(
        setErrorApi({
          data: responseSubmit.data,
          message: responseSubmit.message,
          status: true
        })
      )
    } else {
      if (responseSubmit.data && responseSubmit.data.length > 0) {
        setDataDuplicate(responseSubmit.data)
        setOpenDuplicate(true)
      }
    }
  }

  const AlertDataDuplicate = () => {
    return (
      <Fragment>
        <Dialog
          open={openDuplicate}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseDuplicate()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img
                src={heroPackagePGN.src}
                alt=''
                id='img_heroPackagePGN'
                style={{ paddingTop: '30px', width: '150px' }}
              ></img>
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Mohon Maaf!
              </DialogTitle>
              <DialogContent>
                <div>
                  Data yang sama telah mendaftar berlangganan Gas dan sedang dalam proses evaluasi PGN, yaitu dengan
                  alamat sebagai berikut:
                  {dataDuplicate.length > 0 ? (
                    <ol type='1'>
                      {dataDuplicate.map((item, index) => {
                        return <li key={`data-diplicate-${index}`}>{item.address ?? ''}</li>
                      })}
                    </ol>
                  ) : (
                    ''
                  )}
                  Apakah Anda yakin tetap melanjutkan pendaftaran dengan alamat yang berbeda dengan alamat di atas?
                  <br />
                  <br />
                  Silakan cek progress berlangganan Anda di Aplikasi PGN Mobile dengan link tutorial &ensp;
                  <a href='pgn.id/resetdanprogres' target='_blank'>
                    pgn.id/resetdanprogres
                  </a>
                </div>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={handleCloseDuplicate}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Lanjut Daftar
                </Button>
                <Button
                  variant='outlined'
                  color='error'
                  size='small'
                  onClick={e => window.location.reload()}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Batal Daftar
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  return (
    <Fragment>
      <div style={{ padding: '10px', marginLeft: '10px', minHeight: '500px', width: '100%', paddingBottom: '80px' }}>
        <div style={{ textAlign: 'center' }}>
          <h1>Identitas & Kebutuhan Energi</h1>
          <Typography style={styleText}></Typography>
        </div>
        <Grid container spacing={5}>
          {/* SECTION 1 */}
          <Grid item xs={12} sm={12}>
            <Divider
              sx={{
                '&::before, &::after': {
                  borderColor: 'white'
                },
                '& .MuiDivider-wrapper': { px: 6 }
              }}
            >
              <h3>Identitas Pelanggan</h3>
            </Divider>
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              id='nama'
              fullWidth
              label='Nama *'
              placeholder='Nama'
              value={dataPenggunaan.nama}
              onChange={e => setStateLocal('nama', e.target.value)}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <CleaveWrapper>
              <InputLabel htmlFor='no-telp' style={{ color: 'white' }}>
                Nomor Kartu Tanda Penduduk *
              </InputLabel>
              <Cleave
                id='ktp'
                options={{ blocks: [16], numericOnly: true }}
                style={{ backgroundColor: 'white' }}
                placeholder='0000 0000 0000 0000'
                value={dataPenggunaan.ktp}
                onChange={e => setStateLocal('ktp', e.target.value)}
                onBlur={e => checkDuplicateData()}
              />
            </CleaveWrapper>
          </Grid>

          <Grid item xs={12} sm={6}>
            <CleaveWrapper>
              <InputLabel htmlFor='no-telp' style={{ color: 'white' }}>
                Nomor HP/WhatsApp *
              </InputLabel>
              <Cleave
                id='no-telp'
                options={{ prefix: '+62', blocks: [3, 3, 4, 4], numericOnly: true }}
                style={{ backgroundColor: 'white' }}
                placeholder='000 0000 0000'
                value={dataPenggunaan.no_telpon}
                onChange={e => setStateLocal('no_telpon', e.target.value)}
                onBlur={e => checkDuplicateData()}
              />
            </CleaveWrapper>
          </Grid>

          <Grid item xs={12} sm={6}>
            <CustomTextField
              id='email'
              fullWidth
              label='Email *'
              placeholder='example@mail.com'
              value={dataPenggunaan.email}
              onChange={e => setStateLocal('email', e.target.value)}
            />
          </Grid>

          <Grid item xs={12} sm={6}>
            <InputLabel htmlFor='file_ktp' style={{ color: 'white' }}>
              Unggah KTP *
            </InputLabel>
            <Button
              id='file_ktp'
              component='label'
              variant='outlined'
              color='primary'
              onChange={e => handleFileChange(e, 'ktp_file')}
              style={{ width: '100%', display: 'flex', justifyContent: 'space-between', borderColor: 'white' }}
            >
              <span id='nama_file' style={{ color: 'white', fontSize: '9pt', textAlign: 'left' }}>
                {dataPenggunaan.ktp_file && dataPenggunaan.ktp_file.name
                  ? dataPenggunaan.ktp_file.name
                  : 'Belum Ada Unggahan'}
              </span>
              <VisuallyHiddenInput type='file' accept='image/jpeg, image/jpg, image/png' />
              <span id='btn_file' style={{ color: 'white', fontSize: '10pt', textAlign: 'right', width: '60px' }}>
                Pilih File
              </span>
            </Button>
          </Grid>

          <Grid item xs={12} sm={6}>
            <span style={{ fontSize: '10pt' }}>
              PGN menjamin kerahasiaan data yang Anda sampaikan dan akan digunakan sebagai verifikasi proses
              berlangganan serta potensi data market.
            </span>
          </Grid>

          {/* SECTION 2 */}
          <Grid item xs={12} sm={12}>
            <Divider
              sx={{
                '&::before, &::after': {
                  borderColor: 'white'
                },
                '& .MuiDivider-wrapper': { px: 6 }
              }}
            >
              <h3>Kebutuhan Pelanggan</h3>
            </Divider>
          </Grid>

          {/* Penggunaan Energi Listrik Saat Ini */}
          <Grid item xs={12} sm={12} style={{ display: 'flex', justifyContent: 'center' }}>
            <Grid item xs={12} sm={4}>
              <CustomAutocomplete
                value={dataPenggunaan.energi_listrik}
                open={openPenggunaanEnergi}
                options={optionsPenggunaanEnergi}
                loading={loadingPenggunaanEnergi}
                onOpen={() => {
                  setOpenPenggunaanEnergi(true)
                  setLoadingPenggunaanEnergi(true)
                }}
                onClose={() => {
                  setOpenPenggunaanEnergi(false)
                  setLoadingPenggunaanEnergi(false)
                }}
                onChange={handleSelectPenggunaanEnergi}
                id='select-penggunaan-energi'
                getOptionLabel={option => option.value.toString() || ''}
                isOptionEqualToValue={(option, value) => option.value.toString() === value.value.toString()}
                renderInput={params => (
                  <CustomTextField
                    {...params}
                    label='Penggunaan Energi Listrik Saat Ini (VA) *'
                    InputProps={{
                      ...params.InputProps,
                      endAdornment: (
                        <Fragment>
                          {loadingPenggunaanEnergi ? <CircularProgress size={20} /> : null}
                          {params.InputProps.endAdornment}
                        </Fragment>
                      )
                    }}
                    placeholder='Pilih Penggunaan Energi Listrik'
                  />
                )}
              />
            </Grid>
          </Grid>

          {dataPenggunaan.energi_listrik && dataPenggunaan.energi_listrik.id < 3 && (
            <Grid item xs={12} sm={12} style={{ display: 'flex', justifyContent: 'center' }}>
              <Grid item xs={12} sm={4}>
                <InputLabel htmlFor='rekening_listrik_ktp' style={{ color: 'white', fontSize: '11pt' }}>
                  Unggah Rekening Listrik *
                </InputLabel>
                <Button
                  id='rekening_listrik_ktp'
                  component='label'
                  variant='outlined'
                  color='primary'
                  onChange={e => handleFileChange(e, 'rekening_listrik_file')}
                  style={{ width: '100%', display: 'flex', justifyContent: 'space-between', borderColor: 'white' }}
                >
                  <span id='nama_file' style={{ color: 'white', fontSize: '9pt', textAlign: 'left' }}>
                    {dataPenggunaan.rekening_listrik_file && dataPenggunaan.rekening_listrik_file.name
                      ? dataPenggunaan.rekening_listrik_file.name
                      : 'Belum Ada Unggahan'}
                  </span>
                  <VisuallyHiddenInput type='file' accept='image/jpeg, image/jpg, image/png' />
                  <span id='btn_file' style={{ color: 'white', fontSize: '10pt', textAlign: 'right', width: '60px' }}>
                    Pilih File
                  </span>
                </Button>
              </Grid>
            </Grid>
          )}
          {/* END Penggunaan Energi Listrik Saat Ini */}

          {/* bahan bakar */}

          <Grid item xs={12} sm={12}>
            <Grid container spacing={5}>
              <Grid item xs={12} sm={3}></Grid>

              <Grid item xs={12} sm={6} style={{ display: 'flex', justifyContent: 'center' }}>
                <InputLabel htmlFor='' style={{ color: 'white', fontSize: '11pt' }}>
                  Penggunaan Bahan Bakar dalam 1 Bulan
                </InputLabel>
              </Grid>

              <Grid item xs={12} sm={3}></Grid>

              <BahanBakarItem
                bahan_bakar={dataPenggunaan.bahan_bakar}
                handleClickButtonBahanBakar={handleClickButtonBahanBakar}
              />
            </Grid>
          </Grid>
          {/* END bahan bakar */}

          {/* peralatan */}

          {/* <Grid item xs={12} sm={4}></Grid> */}
          {store.dataKebutuhan == '2' && (
            <Grid item xs={12} sm={12}>
              <Grid container spacing={5}>
                <Grid item xs={12} sm={3}></Grid>

                <Grid item xs={12} sm={6} style={{ display: 'flex', justifyContent: 'center' }}>
                  <InputLabel htmlFor='' style={{ color: 'white', fontSize: '11pt' }}>
                    Jenis Peralatan Gas di Lokasi Anda
                  </InputLabel>
                </Grid>
                <Grid item xs={12} sm={3}></Grid>

                <PeralatanItem
                  peralatan={dataPenggunaan.peralatan}
                  handleClickButtonPeralatan={handleClickButtonPeralatan}
                />
              </Grid>
            </Grid>
          )}

          {/* END peralatan */}

          <AlertDataDuplicate />
        </Grid>
        <Divider sx={{ m: '0 !important' }} />
      </div>
    </Fragment>
  )
}

export default FormLokasiPemasangan
