// ** React Imports
import { forwardRef, useState, Fragment, useEffect, useRef } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Fab from '@mui/material/Fab'
import Checkbox from '@mui/material/Checkbox'
import FormControlLabel from '@mui/material/FormControlLabel'
import Button from '@mui/material/Button'
import DialogTitle from '@mui/material/DialogTitle'
import DialogContent from '@mui/material/DialogContent'
import DialogActions from '@mui/material/DialogActions'
import Dialog from '@mui/material/Dialog'
import DialogContentText from '@mui/material/DialogContentText'
import btoa from 'btoa'

import { useDispatch, useSelector } from 'react-redux'
import { setErrorApi, setPernyataan } from 'src/store/apps/register'

import LokasiPemasanganComponent from './LokasiPemasanganComponent'
import PengguaanIdentitasComponent from './PengguaanIdentitasComponent'

const FormReview = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  const styleText = {
    color: 'white'
  }

  const style_stepper_dot = {
    minWidth: '35px',
    height: '0px',
    marginTop: '',
    marginRight: '10px',
    fontSize: '15pt'
  }

  const [dataPernyataan, setdataPernyataan] = useState({
    pernyataan_1: false,
    pernyataan_2: false,
    pernyataan_3: false
  })

  useEffect(() => {
    window.scrollTo({
      top: 0,
      behavior: 'smooth'
    })
  }, [])

  useEffect(() => {
    dispatch(setPernyataan(dataPernyataan))
  }, [dataPernyataan])

  const setStateLocal = (key, value) => {
    setdataPernyataan(prevState => ({
      ...prevState,
      [key]: value
    }))
  }

  const handleChangePernyataan = (event, action) => {
    setStateLocal(action, event.target.checked)
  }

  // DIALOG
  const [openKebenaranData, setOpenKebenaranData] = useState(false)
  const [openKetentuan, setOpenKetentuan] = useState(false)
  const descriptionElementRef = useRef(null)

  const handleClickOpenPernyataan = action => {
    setOpenKebenaranData(false)
    setOpenKetentuan(false)

    switch (action) {
      case 'pernyataan_1':
        setOpenKebenaranData(true)
        break

      case 'pernyataan_2':
        setOpenKetentuan(true)
        break

      case 'pernyataan_3':
        if (store.dataKonten && store.dataKonten.file_pernyataan && store.dataKonten.file_pernyataan.url) {
          window.open(store.dataKonten.file_pernyataan.url, '_blank')
        }
        break
    }
  }

  const handleCloseKebenaranData = () => {
    setOpenKebenaranData(false)
  }

  const DialogKebenaranData = () => {
    return (
      <Fragment>
        <Dialog
          open={openKebenaranData}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseKebenaranData()
            }
          }}
        >
          <Grid container spacing={5} style={{ userSelect: 'none' }}>
            <Grid item xs={12} sm={12}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Konfirmasi Kebenaran Data
              </DialogTitle>
              <DialogContent dividers={true}>
                {store.dataKonten && store.dataKonten.kebenaran_data && store.dataKonten.kebenaran_data.konten && (
                  <div dangerouslySetInnerHTML={{ __html: atob(store.dataKonten.kebenaran_data.konten) }} />
                )}
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={() => setOpenKebenaranData(false)}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Lanjutkan
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const handleCloseKetentuan = () => {
    setOpenKetentuan(false)
  }

  const DialogKetentuan = () => {
    return (
      <Fragment>
        <Dialog
          open={openKetentuan}
          scroll='paper'
          disableEscapeKeyDown
          aria-labelledby='dialog-ketentuan-title'
          aria-describedby='dialog-ketentuan-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseKetentuan()
            }
          }}
          style={{ userSelect: 'none' }}
        >
          <DialogTitle
            id='dialog-ketentuan-title'
            color={'primary'}
            fontSize={'15pt'}
            sx={{ ...{ pb: theme => `${theme.spacing(5)} !important` } }}
          >
            Ketentuan Umum Berlangganan Gas Pelanggan Rumah Tangga & Pelanggan Kecil
          </DialogTitle>
          <DialogContent dividers={true}>
            {store.dataKonten && store.dataKonten.ketentuan_umum && store.dataKonten.ketentuan_umum.konten && (
              <div dangerouslySetInnerHTML={{ __html: atob(store.dataKonten.ketentuan_umum.konten) }} />
            )}
          </DialogContent>

          <DialogActions
            className='submit-actions-dense'
            sx={{ ...{ p: theme => `${theme.spacing(2.5)} !important` } }}
          >
            <Button
              variant='contained'
              color='success'
              size='small'
              onClick={() => setOpenKetentuan(false)}
              style={{ borderRadius: '25px', width: '130px' }}
            >
              Lanjutkan
            </Button>
          </DialogActions>
        </Dialog>
      </Fragment>
    )
  }

  return (
    <Fragment>
      <div style={{ padding: '10px', marginLeft: '10px', minHeight: '500px', width: '100%', paddingBottom: '80px' }}>
        <Grid container spacing={5}>
          {/* section 1 */}
          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <Fab color='success' aria-label='add' size='small' style={style_stepper_dot}>
                1
              </Fab>
              <h3>
                {store.dataKebutuhan == '1'
                  ? 'Untuk Kebutuhan Sendiri/Rumah Tangga'
                  : 'Kebutuhan Komersial/Jasa (tempat makan, laundry, perkantoran, dan lainnya)'}
              </h3>
              <div
                style={{
                  flex: 1,
                  height: '1px',
                  backgroundColor: 'white', // Set the color of the divider
                  margin: '0 10px' // Adjust margin as needed
                }}
              ></div>
            </div>
          </Grid>

          {/* section 2 */}
          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <Fab color='success' aria-label='add' size='small' style={style_stepper_dot}>
                2
              </Fab>
              <h3>Lokasi Pemasangan</h3>
              <div
                style={{
                  flex: 1,
                  height: '1px',
                  backgroundColor: 'white', // Set the color of the divider
                  margin: '0 10px' // Adjust margin as needed
                }}
              ></div>
            </div>
          </Grid>

          <Grid item xs={12} sm={12}>
            <LokasiPemasanganComponent />
          </Grid>

          {/* section 3 */}
          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <Fab color='success' aria-label='add' size='small' style={style_stepper_dot}>
                3
              </Fab>
              <h3>Identitas & Kebutuhan Energi</h3>
              <div
                style={{
                  flex: 1,
                  height: '1px',
                  backgroundColor: 'white', // Set the color of the divider
                  margin: '0 10px' // Adjust margin as needed
                }}
              ></div>
            </div>
          </Grid>

          <Grid item xs={12} sm={12}>
            <PengguaanIdentitasComponent />
          </Grid>

          {/* section 4 */}
          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <Fab color='success' aria-label='add' size='small' style={style_stepper_dot}>
                4
              </Fab>
              <h3>Pernyataan</h3>
              <div
                style={{
                  flex: 1,
                  height: '1px',
                  backgroundColor: 'white', // Set the color of the divider
                  margin: '0 10px' // Adjust margin as needed
                }}
              ></div>
            </div>
          </Grid>

          <Grid item xs={12} sm={12}>
            Pastikan bahwa data yang diisi telah sesuai. Silakan membaca segala ketentuan dan persyaratan yang berlaku
            terkait dengan ketentuan umum berlangganan gas PGN lalu mencentang pilihan yang tercantum dibawah ini untuk
            melanjutkan proses permohonan berlangganan.
          </Grid>

          <Grid item xs={12} sm={12}>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <div>
                <FormControlLabel
                  id='pernyataan-1'
                  sx={{ '& svg': { height: 30, width: 30, stroke: 'white' } }}
                  control={<Checkbox onChange={e => handleChangePernyataan(e, 'pernyataan_1')} />}
                ></FormControlLabel>
              </div>
              <div style={{ marginLeft: '-20px' }}>
                <span
                  onClick={e => handleClickOpenPernyataan('pernyataan_1')}
                  style={{ cursor: 'pointer', color: '#ADC52D' }}
                >
                  Saya menjamin kebenaran data pada formulir ini
                </span>
              </div>
            </div>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <div>
                <FormControlLabel
                  id='pernyataan-2'
                  sx={{ '& svg': { height: 30, width: 30, stroke: 'white' } }}
                  control={<Checkbox onChange={e => handleChangePernyataan(e, 'pernyataan_2')} />}
                />
              </div>
              <div style={{ marginLeft: '-20px' }}>
                Saya menyetujui segala ketentuan yang berlaku dalam&ensp;
                <span
                  onClick={e => handleClickOpenPernyataan('pernyataan_2')}
                  style={{ cursor: 'pointer', color: '#ADC52D' }}
                >
                  ketentuan umum berlangganan Gas PGN
                </span>{' '}
                dan perubahannya (jika ada).
              </div>
            </div>
            <div style={{ display: 'flex', alignItems: 'center' }}>
              <div>
                <FormControlLabel
                  id='pernyataan-3'
                  sx={{ '& svg': { height: 30, width: 30, stroke: 'white' } }}
                  control={<Checkbox onChange={e => handleChangePernyataan(e, 'pernyataan_3')} />}
                />
              </div>
              <div style={{ marginLeft: '-20px' }}>
                Saya menyetujui&ensp;
                <span
                  onClick={e => handleClickOpenPernyataan('pernyataan_3')}
                  style={{ cursor: 'pointer', color: '#ADC52D' }}
                >
                  pemasangan pipa instalasi, pipa servis, & Meter Gas
                </span>{' '}
                (klik untuk lebih detail) serta jadwal pengaliran Gas (Gas In) yang akan dilakukan oleh petugas PGN.
              </div>
            </div>
          </Grid>

          {/* DIALOG */}
          <DialogKebenaranData />
          <DialogKetentuan />
        </Grid>
      </div>
    </Fragment>
  )
}

export default FormReview
