import React, { useState, useEffect } from 'react'
import { GoogleMap, LoadScript, Marker } from '@react-google-maps/api'
import {
  setKey,
  setDefaults,
  setLanguage,
  setRegion,
  fromAddress,
  fromLatLng,
  fromPlaceId,
  setLocationType,
  geocode,
  RequestType
} from 'react-geocode'

const GoogleMaps = ({ latitude, longitude, dataLokasiPemasangan, setStateLocal }) => {
  const [markers, setMarkers] = useState({
    lat: latitude,
    lng: longitude
  })

  const [center, setCenter] = useState({
    lat: latitude,
    lng: longitude
  })
  const [zoom, setZoom] = useState(12)

  setKey(process.env.NEXT_PUBLIC_GOOGLE_API_KEY)
  setLanguage('id')

  const mapContainerStyle = {
    width: '100%',
    height: '400px'
  }

  const handleMapClick = event => {
    const markerBaru = {
      lat: event.latLng.lat(),
      lng: event.latLng.lng()
    }

    setMarkers(markerBaru)
    setStateLocal('tagging_map', true)
  }

  useEffect(() => {
    setStateLocal('latitude', markers.lat)
    setStateLocal('longitude', markers.lng)
  }, [markers])

  useEffect(() => {
    handleSearchMap('provinsi', 12)
  }, [dataLokasiPemasangan.provinsi])

  useEffect(() => {
    handleSearchMap('kota', 14)
  }, [dataLokasiPemasangan.kota])

  useEffect(() => {
    handleSearchMap('kecamatan', 15)
  }, [dataLokasiPemasangan.kecamatan])

  useEffect(() => {
    handleSearchMap('kelurahan', 16)
  }, [dataLokasiPemasangan.kelurahan])

  useEffect(() => {
    handleSearchMap('perumahan', 18)
  }, [dataLokasiPemasangan.select_perumahan_jalan_utama])

  useEffect(() => {
    const markerBaru = {
      lat: latitude,
      lng: longitude
    }

    setMarkers(markerBaru)
    setCenter(markerBaru)
  }, [latitude, longitude])

  const handleSearchMap = async (action, temp_zoom) => {
    try {
      let searchLocation = ''
      let temp_provinsi = dataLokasiPemasangan.provinsi ? dataLokasiPemasangan.provinsi.name : ''
      let temp_kota = dataLokasiPemasangan.kota ? dataLokasiPemasangan.kota.name : ''
      let temp_kecamatan = dataLokasiPemasangan.kecamatan ? dataLokasiPemasangan.kecamatan.name : ''
      let temp_kelurahan = dataLokasiPemasangan.kelurahan ? dataLokasiPemasangan.kelurahan.name : ''

      let temp_perumahan = dataLokasiPemasangan.select_perumahan_jalan_utama
        ? dataLokasiPemasangan.select_perumahan_jalan_utama.name
        : ''

      switch (action) {
        case 'provinsi':
          searchLocation = `${temp_provinsi}`
          break

        case 'kota':
          searchLocation = `${temp_kota} ${temp_provinsi}`
          break

        case 'kecamatan':
          searchLocation = `${temp_kecamatan} ${temp_kota} ${temp_provinsi}`
          break

        case 'kelurahan':
          searchLocation = `${temp_kelurahan} ${temp_kecamatan} ${temp_kota} ${temp_provinsi}`
          break

        case 'perumahan':
          searchLocation = `${temp_perumahan} ${temp_kelurahan} ${temp_kecamatan} ${temp_kota} ${temp_provinsi}`
          break
      }

      if (searchLocation.replaceAll(' ', '') != '') {
        const response = await fromAddress(searchLocation)
        if (response.results[0].geometry.location) {
          const { lat, lng } = response.results[0].geometry.location
          setMarkers({ lat, lng })
          setCenter({ lat, lng })
          setZoom(temp_zoom)
        }
      }

      // console.error('sukses searching location:', [{ id: 1, lat, lng }])

      // setMarkers([{ id: 1, lat, lng }]);
    } catch (error) {
      console.error('Error searching location:', error)
    }
  }

  return (
    <LoadScript googleMapsApiKey={process.env.NEXT_PUBLIC_GOOGLE_API_KEY}>
      <GoogleMap mapContainerStyle={mapContainerStyle} center={center} zoom={zoom} onClick={handleMapClick}>
        <Marker position={markers} draggable={true} onDragEnd={e => setMarkers(e.latLng.toJSON())} />
      </GoogleMap>
    </LoadScript>
  )
}

export default GoogleMaps
