// components/Map.js
import { GoogleMap, LoadScript, Marker } from '@react-google-maps/api'

const GoogleMapsView = ({ latitude, longitude }) => {
  const mapContainerStyle = {
    width: '100%',
    height: '400px'
  }

  const center = {
    lat: latitude,
    lng: longitude
  }

  return (
    <LoadScript googleMapsApiKey={process.env.NEXT_PUBLIC_GOOGLE_API_KEY}>
      <GoogleMap mapContainerStyle={mapContainerStyle} center={center} zoom={18}>
        {/* Tambahkan marker atau konten lainnya di sini */}
        <Marker position={center} />
      </GoogleMap>
    </LoadScript>
  )
}

export default GoogleMapsView
