// ** React Imports
import { Fragment, useState } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Button from '@mui/material/Button'
import Divider from '@mui/material/Divider'
import CustomTextField from 'src/@core/components/mui/text-field'
import { styled } from '@mui/material/styles'
import MuiInputLabel from '@mui/material/InputLabel'

import { useDispatch, useSelector } from 'react-redux'
import GoogleMapsView from 'src/views/register/components/GoogleMapsView'
import DigioMapsView from 'src/views/register/components/DigioMapsView'

const InputLabel = styled(MuiInputLabel)(({ theme }) => ({
  lineHeight: 1.154,
  maxWidth: 'max-content',
  marginBottom: theme.spacing(1),
  color: theme.palette.text.primary,
  fontSize: theme.typography.body2.fontSize
}))

const LokasiPemasanganComponent = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  const [isDigioMapsLoaded, setIsDigioMapsLoaded] = useState(true)

  const handleDigioMapsError = () => {
    setIsDigioMapsLoaded(false)
  }

  return (
    <Fragment>
      <Grid container spacing={5}>
        {/* SECTION 1 */}

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Provinsi'
            placeholder=''
            value={store.dataLokasiPemasangan.provinsi?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Kota/Kabupaten'
            placeholder=''
            value={store.dataLokasiPemasangan.kota?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Kecamatan'
            placeholder=''
            value={store.dataLokasiPemasangan.kecamatan?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Kelurahan'
            placeholder=''
            value={store.dataLokasiPemasangan.kelurahan?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Perumahan/Jalan Utama'
            placeholder=''
            value={store.dataLokasiPemasangan.select_perumahan_jalan_utama?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Nama Perumahan/Jalan Utama Lainnya'
            placeholder=''
            value={store.dataLokasiPemasangan.nama_perumahan_jalan_utama}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='RT'
            placeholder=''
            value={store.dataLokasiPemasangan.rt}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='RW'
            placeholder=''
            value={store.dataLokasiPemasangan.rw}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='Kode Pos'
            placeholder=''
            value={store.dataLokasiPemasangan.kode_pos}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={12}>
          <CustomTextField
            fullWidth
            label='Alamat'
            placeholder=''
            value={store.dataLokasiPemasangan.alamat}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Jenis Bangunan'
            placeholder=''
            value={store.dataLokasiPemasangan.jenis_bangunan?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <span style={{ fontSize: '10pt' }}>Status Lokasi Pemasangan</span>
          <br />
          <Grid container spacing={5}>
            {store.dataLokasiPemasangan.status_lokasi_pemasangan == 0 && (
              <Fragment>
                <Grid item xs={6} sm={6}>
                  <Button variant='contained' color='success' size='medium' fullWidth>
                    <span style={{ fontSize: '10pt' }}>Milik Pribadi</span>
                  </Button>
                </Grid>
              </Fragment>
            )}

            {store.dataLokasiPemasangan.status_lokasi_pemasangan == 1 && (
              <Fragment>
                <Grid item xs={6} sm={6}>
                  <Button variant='contained' color='success' size='medium' fullWidth>
                    <span style={{ fontSize: '10pt' }}>Milik Pemerintah</span>
                  </Button>
                </Grid>
              </Fragment>
            )}
          </Grid>
        </Grid>

        {/* MAP, di disable */}
        {/* <Grid item xs={12} sm={12}>
          <InputLabel htmlFor='map' style={{ color: 'white' }}>
            Peta Lokasi
          </InputLabel>

          {store.dataMap ? (
            <DigioMapsView
              latitude={store.dataLokasiPemasangan.latitude}
              longitude={store.dataLokasiPemasangan.longitude}
              onError={handleDigioMapsError}
            />
          ) : (
            <GoogleMapsView
              latitude={store.dataLokasiPemasangan.latitude}
              longitude={store.dataLokasiPemasangan.longitude}
            />
          )}
        </Grid> */}

        <Grid item xs={12} sm={12}>
          <CustomTextField
            fullWidth
            label='Status Kepemilikan'
            placeholder=''
            value={store.dataLokasiPemasangan.status_kepemilikan?.name}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        {store.dataLokasiPemasangan.status_kepemilikan && store.dataLokasiPemasangan.status_kepemilikan.id == 2 ? (
          <Fragment>
            <Grid item xs={12} sm={6}>
              <CustomTextField
                fullWidth
                label='Nama Pemilik Bangunan'
                placeholder=''
                value={store.dataLokasiPemasangan.nama_pemilik_bangunan}
                InputProps={{ readOnly: true }}
              />
            </Grid>

            <Grid item xs={12} sm={6}>
              <CustomTextField
                fullWidth
                label='No Telpon/HP Pemilik Bangunan'
                placeholder=''
                value={store.dataLokasiPemasangan.no_telpon}
                InputProps={{ readOnly: true }}
              />
            </Grid>
          </Fragment>
        ) : (
          ''
        )}
      </Grid>
      <Divider sx={{ m: '0 !important' }} />
    </Fragment>
  )
}

export default LokasiPemasanganComponent
