// ** React Imports
import React, { Fragment } from 'react'

// ** MUI Imports
import Grid from '@mui/material/Grid'
import Button from '@mui/material/Button'
import Divider from '@mui/material/Divider'
import CustomTextField from 'src/@core/components/mui/text-field'
import Card from '@mui/material/Card'
import CardContent from '@mui/material/CardContent'
import Typography from '@mui/material/Typography'
import Box from '@mui/material/Box'
import CustomTimelineDot from 'src/@core/components/mui/timeline-dot'
import Icon from 'src/@core/components/icon'
import TextFieldAlat from 'src/@core/components/mui/text-field/textFieldAlat'
import { styled } from '@mui/material/styles'
import MuiInputLabel from '@mui/material/InputLabel'

import { useDispatch, useSelector } from 'react-redux'

const InputLabel = styled(MuiInputLabel)(({ theme }) => ({
  lineHeight: 1.154,
  maxWidth: 'max-content',
  marginBottom: theme.spacing(1),
  color: theme.palette.text.primary,
  fontSize: '11pt'
}))

const PengguaanIdentitasComponent = () => {
  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  const BahanBakarItem = React.memo(({ bahan_bakar }) => {
    const temp = bahan_bakar.filter(data => data.value != '' && parseInt(data.value) > 0)

    const items = temp.map(data => (
      <Grid key={data.id} item xs={6} sm={3}>
        <Card
          sx={{
            height: '220px',
            backgroundColor: data.backgroundColor,
            border: '1px solid white',
            textAlign: 'center'
          }}
        >
          <CardContent style={{ paddingLeft: '0', paddingRight: '0' }}>
            <Typography sx={{ color: 'white', fontSize: '10pt' }}>{data.name}</Typography>
            <img src={data.full_icon_url} alt='' style={{ height: '100px' }}></img>

            <Box sx={{ display: 'inline-flex', width: '100%' }}>
              <Grid container spacing={0} alignItems='center'>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}></Grid>
                <Grid item xs={6}>
                  <TextFieldAlat
                    size='small'
                    id='input-with-icon-grid'
                    InputProps={{ readOnly: true }}
                    value={data.value}
                  />
                </Grid>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}></Grid>
              </Grid>
            </Box>
          </CardContent>
        </Card>
      </Grid>
    ))

    return <Fragment>{items}</Fragment>
  })

  const PeralatanItem = React.memo(({ peralatan }) => {
    const temp = peralatan.filter(data => data.value != '' && parseInt(data.value) > 0)

    const items = temp.map(data => (
      <Grid key={data.id} item xs={6} sm={3}>
        <Card
          sx={{
            height: '220px',
            backgroundColor: data.backgroundColor,
            border: '1px solid white',
            textAlign: 'center'
          }}
        >
          <CardContent style={{ paddingLeft: '0', paddingRight: '0' }}>
            <Typography sx={{ color: 'white', fontSize: '10pt' }}>{data.name}</Typography>
            <img src={data.full_icon_url} alt='' style={{ height: '100px' }}></img>

            <Box sx={{ display: 'inline-flex', width: '100%' }}>
              <Grid container spacing={0} alignItems='center'>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}></Grid>
                <Grid item xs={6}>
                  <TextFieldAlat
                    size='small'
                    id='input-with-icon-grid'
                    InputProps={{ readOnly: true }}
                    value={data.value}
                  />
                </Grid>
                <Grid item xs={3} style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}></Grid>
              </Grid>
            </Box>
          </CardContent>
        </Card>
      </Grid>
    ))

    return <Fragment>{items}</Fragment>
  })

  return (
    <Fragment>
      <Grid container spacing={5}>
        {/* SECTION 1 */}

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Nama'
            placeholder='Nama'
            value={store.dataPenggunaan.nama}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={6}>
          <CustomTextField
            fullWidth
            label='Nomor Kartu Tanda Penduduk'
            placeholder='Nomor Kartu Tanda Penduduk'
            value={store.dataPenggunaan.ktp}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='Nomor Telepon/HP'
            placeholder='Nomor Telepon/HP'
            value={store.dataPenggunaan.no_telpon}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={4}>
          <CustomTextField
            fullWidth
            label='Email'
            placeholder='Email'
            value={store.dataPenggunaan.email}
            InputProps={{ readOnly: true }}
          />
        </Grid>

        <Grid item xs={12} sm={4}>
          <InputLabel htmlFor='file_ktp' style={{ color: 'white' }}>
            Unggah KTP
          </InputLabel>
          <Button
            id='file_ktp'
            component='label'
            variant='outlined'
            color='primary'
            style={{ width: '100%', display: 'flex', justifyContent: 'space-between', borderColor: 'white' }}
          >
            <span id='nama_file' style={{ color: 'white', fontSize: '10pt', textAlign: 'left' }}>
              {store.dataPenggunaan.ktp_file && store.dataPenggunaan.ktp_file.name
                ? store.dataPenggunaan.ktp_file.name
                : 'Belum Ada Unggahan'}
            </span>
          </Button>
        </Grid>

        <Grid item xs={12} sm={12}>
          <Divider
            sx={{
              '&::before, &::after': {
                borderColor: 'white'
              },
              '& .MuiDivider-wrapper': { px: 0 }
            }}
          >
            <span />
          </Divider>
        </Grid>

        <Grid item xs={12} sm={12}>
          <div style={{ display: 'flex', alignItems: 'center' }}>
            <span style={{ fontSize: '11pt' }}>Penggunaan Energi Listrik Saat Ini (VA)</span>
            <Button
              variant='contained'
              color='success'
              size='medium'
              fullWidth
              style={{ width: '150px', marginLeft: '5px' }}
            >
              <span style={{ fontSize: '10pt' }}>{store.dataPenggunaan.energi_listrik?.value} Kwh</span>
            </Button>
          </div>
        </Grid>

        {store.dataPenggunaan.energi_listrik && store.dataPenggunaan.energi_listrik.id < 3 && (
          <Grid item xs={12} sm={4}>
            <InputLabel htmlFor='rekening_listrik_ktp' style={{ color: 'white' }}>
              Unggah Rekening Listrik
            </InputLabel>
            <Button
              id='rekening_listrik_ktp'
              component='label'
              variant='outlined'
              color='primary'
              style={{ width: '100%', display: 'flex', justifyContent: 'space-between', borderColor: 'white' }}
            >
              <span id='nama_file' style={{ color: 'white', fontSize: '10pt', textAlign: 'left' }}>
                {store.dataPenggunaan.rekening_listrik_file && store.dataPenggunaan.rekening_listrik_file.name
                  ? store.dataPenggunaan.rekening_listrik_file.name
                  : 'Belum Ada Unggahan'}
              </span>
            </Button>
          </Grid>
        )}

        <Grid item xs={12} sm={12}>
          <span style={{ fontSize: '11pt' }}>Penggunaan Bahan Bakar dalam 1 Bulan</span>
        </Grid>

        <BahanBakarItem bahan_bakar={store.dataPenggunaan.bahan_bakar} />

        {store.dataKebutuhan == '2' && (
          <Fragment>
            <Grid item xs={12} sm={12}>
              <span style={{ fontSize: '11pt' }}>Jenis Peralatan Gas di Lokasi Anda</span>
            </Grid>

            <PeralatanItem peralatan={store.dataPenggunaan.peralatan} />
          </Fragment>
        )}
      </Grid>
    </Fragment>
  )
}

export default PengguaanIdentitasComponent
