// ** React Imports
import { Fragment, useState, useEffect } from 'react'

// ** MUI Imports
import Box from '@mui/material/Box'
import Card from '@mui/material/Card'
import Step from '@mui/material/Step'
import Grid from '@mui/material/Grid'
import Button from '@mui/material/Button'
import Stepper from '@mui/material/Stepper'
import StepLabel from '@mui/material/StepLabel'
import Typography from '@mui/material/Typography'
import CardContent from '@mui/material/CardContent'
import Radio from '@mui/material/Radio'
import RadioGroup from '@mui/material/RadioGroup'
import FormControlLabel from '@mui/material/FormControlLabel'
import StepperCustomDot from './StepperCustomDot'
import toast from 'react-hot-toast'

import Dialog from '@mui/material/Dialog'
import DialogTitle from '@mui/material/DialogTitle'
import DialogContent from '@mui/material/DialogContent'
import DialogActions from '@mui/material/DialogActions'
import DialogContentText from '@mui/material/DialogContentText'

import { styled } from '@mui/material/styles'
import CircularProgress from '@mui/material/CircularProgress'

// PGN
import StepperWrapper from 'src/@core/styles/mui/stepper'
import FormLokasiPemasangan from './components/FormLokasiPemasangan'
import FormPengguaanIdentitas from './components/FormPengguaanIdentitas'
import FormReview from './components/FormReview'
import FormBerhasil from './components/FormBerhasil'

import heroManPGN from 'public/images/pgn/pgn_hero_man.png'
import heroWomanPGN from 'public/images/pgn/pgn_hero_women.png'
import heroPipePGN from 'public/images/pgn/pgn_hero_pipe.png'
import textGaskitaWhite from 'public/images/pgn/text_gaskita_white.png'
import heroPackagePGN from 'public/images/pgn/pgn_hero_package.png'
import successPGN from 'public/images/pgn/success.png'
import failedPGN from 'public/images/pgn/failed.png'
import warningPGN from 'public/images/pgn/warning.png'

import { useDispatch, useSelector } from 'react-redux'
import {
  setErrorApi,
  setKebutuhan,
  setLokasiPemasangan,
  setPenggunaan,
  setPernyataan,
  setResponseRegistrasi,
  setKonten
} from 'src/store/apps/register'

import { callPost, callGet } from 'src/service/api'
import { Endpoint, ValidateRequiredMessage } from 'src/service/constant'

const steps = [
  {
    title: 'Kebutuhan',
    subtitle: ''
  },
  {
    title: 'Lokasi',
    subtitle: ''
  },
  {
    title: 'Identitas & Kebutuhan Energi',
    subtitle: ''
  },
  {
    title: 'Review',
    subtitle: ''
  },
  {
    title: 'Berhasil',
    subtitle: ''
  }
]

const StepperRegister = () => {
  const [activeStep, setActiveStep] = useState(0)
  const [heightCard, setHeightCard] = useState('500px')

  const dispatch = useDispatch()
  const store = useSelector(state => state.register)

  const [openSubmit, setOpenSubmit] = useState(false)
  const handleCloseSubmit = () => setOpenSubmit(false)

  const [openDuplicate, setOpenDuplicate] = useState(false)
  const handleCloseDuplicate = () => setOpenDuplicate(false)

  const [openSuccess, setOpenSuccess] = useState(false)

  const handleCloseSuccess = () => {
    if (
      store.dataResponseRegistrasi &&
      store.dataResponseRegistrasi.data &&
      store.dataResponseRegistrasi.data.katalog_produk.length > 0
    ) {
      setOpenSuccess(false)
      setActiveStep(4)
    } else {
      window.location.reload()
    }
  }

  const [openFailed, setOpenFailed] = useState(false)
  const handleCloseFailed = () => setOpenFailed(false)

  const [openConfirm, setOpenConfirm] = useState(false)

  const handleCloseConfirm = () => {
    setOpenConfirm(false)
    handleClickSubmit()
  }

  const handleClickSubmit = async () => {
    dispatch(
      setErrorApi({
        data: {},
        message: '',
        status: false
      })
    )

    setOpenSubmit(true)

    // setOpenDuplicate(false)
    setOpenSuccess(false)
    setOpenFailed(false)

    const payload = new FormData()

    payload.append('kebutuhan_pelanggan', store.dataKebutuhan)
    payload.append('lokasi_pemasangan.provinsi', store.dataLokasiPemasangan.provinsi.id)
    payload.append('lokasi_pemasangan.kota', store.dataLokasiPemasangan.kota.id)
    payload.append('lokasi_pemasangan.kecamatan', store.dataLokasiPemasangan.kecamatan.id)
    payload.append('lokasi_pemasangan.kelurahan', store.dataLokasiPemasangan.kelurahan.id)
    payload.append('lokasi_pemasangan.alamat', store.dataLokasiPemasangan.alamat)

    if (store.dataLokasiPemasangan.select_perumahan_jalan_utama != null) {
      payload.append(
        'lokasi_pemasangan.perumahan_jalan_utama',
        store.dataLokasiPemasangan.select_perumahan_jalan_utama.id
      )
    }
    if (store.dataLokasiPemasangan.nama_perumahan_jalan_utama.replaceAll(' ', '') != '') {
      payload.append(
        'lokasi_pemasangan.nama_perumahan_jalan_utama',
        store.dataLokasiPemasangan.nama_perumahan_jalan_utama
      )
    }

    if (store.dataLokasiPemasangan.rt.replaceAll(' ', '') != '') {
      payload.append('lokasi_pemasangan.rt', store.dataLokasiPemasangan.rt)
    }
    if (store.dataLokasiPemasangan.rw.replaceAll(' ', '') != '') {
      payload.append('lokasi_pemasangan.rw', store.dataLokasiPemasangan.rw)
    }
    if (store.dataLokasiPemasangan.kode_pos.replaceAll(' ', '') != '') {
      payload.append('lokasi_pemasangan.kode_pos', store.dataLokasiPemasangan.kode_pos)
    }

    payload.append('lokasi_pemasangan.jenis_bangunan', store.dataLokasiPemasangan.jenis_bangunan.id)
    payload.append('lokasi_pemasangan.status_kepemilikan', store.dataLokasiPemasangan.status_kepemilikan.id)

    if (store.dataLokasiPemasangan.nama_pemilik_bangunan.replaceAll(' ', '') != '') {
      payload.append('lokasi_pemasangan.nama_pemilik_bangunan', store.dataLokasiPemasangan.nama_pemilik_bangunan)
    }

    if (store.dataLokasiPemasangan.no_telpon.replaceAll('+', '').replaceAll(' ', '') != '') {
      payload.append(
        'lokasi_pemasangan.no_telpon',
        store.dataLokasiPemasangan.no_telpon.replaceAll('+', '').replaceAll(' ', '')
      )
    }

    payload.append('lokasi_pemasangan.status_lokasi_pemasangan', store.dataLokasiPemasangan.status_lokasi_pemasangan)
    payload.append('lokasi_pemasangan.latitude', store.dataLokasiPemasangan.latitude)
    payload.append('lokasi_pemasangan.longitude', store.dataLokasiPemasangan.longitude)

    payload.append('penggunaan.nama', store.dataPenggunaan.nama)
    payload.append('penggunaan.ktp', store.dataPenggunaan.ktp)
    payload.append('penggunaan.ktp_file', store.dataPenggunaan.ktp_file)
    payload.append('penggunaan.no_telpon', store.dataPenggunaan.no_telpon.replaceAll('+', '').replaceAll(' ', ''))
    payload.append('penggunaan.email', store.dataPenggunaan.email)
    payload.append('penggunaan.energi_listrik', store.dataPenggunaan.energi_listrik.id)

    if (store.dataPenggunaan.energi_listrik.id < 3) {
      payload.append('penggunaan.rekening_listrik_file', store.dataPenggunaan.rekening_listrik_file)
    }

    let temp_bahan_bakar = store.dataPenggunaan.bahan_bakar
      .filter(item => item.value != '' && parseInt(item.value) > 0)
      .map(item => ({
        id: item.id,
        value: item.value
      }))

    temp_bahan_bakar.map((item, index) => {
      payload.append(`penggunaan.bahan_bakar[${index}][id]`, item.id)
      payload.append(`penggunaan.bahan_bakar[${index}][value]`, item.value)
    })

    if (store.dataKebutuhan == '2') {
      let temp_peralatan = store.dataPenggunaan.peralatan
        .filter(item => item.value != '' && parseInt(item.value) > 0)
        .map(item => ({
          id: item.id,
          value: item.value
        }))

      temp_peralatan.map((item, index) => {
        payload.append(`penggunaan.peralatan[${index}][id]`, item.id)
        payload.append(`penggunaan.peralatan[${index}][value]`, item.value)
      })
    }

    const responseSubmit = await callPost(Endpoint.postRegister, payload)
    setOpenSubmit(false)
    if (!responseSubmit.status) {
      if (responseSubmit.message == 'duplicate data') {
        // setOpenDuplicate(true)
      } else if (responseSubmit.message == 'Failed validation') {
        dispatch(
          setErrorApi({
            data: responseSubmit.data,
            message: responseSubmit.message,
            status: true
          })
        )
      } else {
        setOpenFailed(true)
      }
    } else {
      dispatch(
        setResponseRegistrasi({
          data: responseSubmit.data,
          message: responseSubmit.message,
          status: true
        })
      )

      // setActiveStep(4)

      setOpenSuccess(true)

      // handleReset()
    }
  }

  useEffect(() => {
    // console.log("store = ",store)
  }, [dispatch, store])

  useEffect(() => {
    if (store.dataErrorApi.status) {
      if (store.dataErrorApi.data.errors) {
        for (let field in store.dataErrorApi.data.errors) {
          let errorMessages = store.dataErrorApi.data.errors[field]
          errorMessages.forEach(errorMessage => {
            toast.error(errorMessage)
          })
        }
      } else {
        toast.error(store.dataErrorApi.message)
      }
    }
  }, [dispatch, store.dataErrorApi])

  useEffect(() => {
    if (activeStep > 0) {
      setHeightCard('auto')
    } else {
      setHeightCard('500px')
    }
  }, [activeStep])

  useEffect(() => {
    fetchDataKonten()
  }, [])

  const fetchDataKonten = async () => {
    const responseKonten = await callGet(Endpoint.getKonten)

    if (responseKonten.status) {
      dispatch(setKonten(responseKonten.data.data))
    }
  }

  // Handle Stepper
  const handleBack = () => {
    if (activeStep > 0) {
      setActiveStep(prevActiveStep => prevActiveStep - 1)
    }
  }

  const handleNext = () => {
    if (formValidate(activeStep)) {
      if (activeStep === 3) {
        // handleClickSubmit()
        setOpenConfirm(true)
      } else {
        setActiveStep(prevActiveStep => prevActiveStep + 1)
      }
    }
  }

  const handleReset = () => {
    // setActiveStep(0)

    dispatch(
      setErrorApi({
        data: {},
        message: '',
        status: false
      })
    )
    dispatch(setKebutuhan('1'))
    dispatch(
      setLokasiPemasangan({
        provinsi: null,
        kota: null,
        kecamatan: null,
        kelurahan: null,
        select_perumahan_jalan_utama: null,
        nama_perumahan_jalan_utama: '',
        rt: '',
        rw: '',
        kode_pos: '',
        alamat: '',
        jenis_bangunan: null,
        status_lokasi_pemasangan: 0,
        status_kepemilikan: null,
        nama_pemilik_bangunan: '',
        no_telpon: '',
        latitude: -6.2088,
        longitude: 106.8456,
        maps: 1
      })
    )
    dispatch(
      setPenggunaan({
        nama: '',
        ktp: '',
        no_telpon: '',
        email: '',
        ktp_file: null,
        energi_listrik: null,
        rekening_listrik_file: null,
        bahan_bakar: [],
        peralatan: []
      })
    )
    dispatch(
      setPernyataan({
        pernyataan_1: false,
        pernyataan_2: false
      })
    )
  }

  const handleDownloadBrosur = () => {
    if (store.dataKonten && store.dataKonten.brosur && store.dataKonten.brosur.url) {
      window.open(store.dataKonten.brosur.url, '_blank')
    }
  }

  // STATE PGN
  const [radioKebutuhan, setRadioKebutuhan] = useState('1')

  const changeRadioKebutuhan = event => {
    setRadioKebutuhan(event.target.value)
    dispatch(setKebutuhan(event.target.value))
  }

  const validateEmail = email => {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/

    return emailRegex.test(email)
  }

  const formValidate = step => {
    switch (step) {
      case 0:
        return formValidateKebutuhan()
      case 1:
        return formValidateLokasiPemasangan()
      case 2:
        return formValidatePenggunaan()
      case 3:
        return formValidatePernyataan()
    }
  }

  const formValidateKebutuhan = () => {
    if (store.dataKebutuhan != '1' && store.dataKebutuhan != '2') {
      toast.error(ValidateRequiredMessage.dataKebutuhan)

      return false
    }

    return true
  }

  const formValidateLokasiPemasangan = () => {
    if (store.dataLokasiPemasangan.provinsi == null) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.provinsi)

      return false
    }
    if (store.dataLokasiPemasangan.kota == null) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.kota)

      return false
    }
    if (store.dataLokasiPemasangan.kecamatan == null) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.kecamatan)

      return false
    }
    if (store.dataLokasiPemasangan.kelurahan == null) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.kelurahan)

      return false
    }

    if (store.dataLokasiPemasangan.select_perumahan_jalan_utama == null) {
      if (store.dataLokasiPemasangan.nama_perumahan_jalan_utama == '') {
        toast.error(ValidateRequiredMessage.dataLokasiPemasangan.nama_perumahan_jalan_utama)

        return false
      }
    }

    if (store.dataLokasiPemasangan.alamat == '') {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.alamat)

      return false
    }
    if (store.dataLokasiPemasangan.jenis_bangunan == null) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.jenis_bangunan)

      return false
    }
    if (
      store.dataLokasiPemasangan.status_lokasi_pemasangan != 0 &&
      store.dataLokasiPemasangan.status_lokasi_pemasangan != 1
    ) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.status_lokasi_pemasangan)

      return false
    }
    if (store.dataLokasiPemasangan.status_kepemilikan == null) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.status_kepemilikan)

      return false
    }

    if (store.dataLokasiPemasangan.status_kepemilikan.id == 2) {
      if (store.dataLokasiPemasangan.nama_pemilik_bangunan == '') {
        toast.error(ValidateRequiredMessage.dataLokasiPemasangan.nama_pemilik_bangunan)

        return false
      }
      if (store.dataLokasiPemasangan.no_telpon == '+62 ') {
        toast.error(ValidateRequiredMessage.dataLokasiPemasangan.no_telpon)

        return false
      }
      if (store.dataLokasiPemasangan.no_telpon.replaceAll(' ', '').replaceAll('+', '').length < 11) {
        toast.error(ValidateRequiredMessage.dataLokasiPemasangan.no_telpon_panjang)

        return false
      }
    }
    console.log(store.dataLokasiPemasangan.tagging_map)
    if (!store.dataLokasiPemasangan.tagging_map) {
      toast.error(ValidateRequiredMessage.dataLokasiPemasangan.tagging_map)

      return false
    }

    return true
  }

  const formValidatePenggunaan = () => {
    if (store.dataPenggunaan.nama == '') {
      toast.error(ValidateRequiredMessage.dataPenggunaan.nama)

      return false
    }
    if (store.dataPenggunaan.ktp == '') {
      toast.error(ValidateRequiredMessage.dataPenggunaan.ktp)

      return false
    }
    if (store.dataPenggunaan.ktp.length != 16) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.ktp_panjang)

      return false
    }
    if (store.dataPenggunaan.no_telpon == '+62 ') {
      toast.error(ValidateRequiredMessage.dataPenggunaan.no_telpon)

      return false
    }
    if (store.dataPenggunaan.no_telpon.replaceAll(' ', '').replaceAll('+', '').length < 11) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.no_telpon_panjang)

      return false
    }

    if (store.dataPenggunaan.email == '') {
      toast.error(ValidateRequiredMessage.dataPenggunaan.email)

      return false
    }
    if (!validateEmail(store.dataPenggunaan.email)) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.email_format)

      return false
    }
    if (store.dataPenggunaan.ktp_file == null) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.ktp_file)

      return false
    }
    if (store.dataPenggunaan.energi_listrik == null) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.energi_listrik)

      return false
    }
    if (store.dataPenggunaan.energi_listrik.id < 3 && store.dataPenggunaan.rekening_listrik_file == null) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.rekening_listrik_file)

      return false
    }

    const temp_bahan_bakar = store.dataPenggunaan.bahan_bakar.filter(
      item => item.value != '' && parseInt(item.value) > 0
    )
    if (temp_bahan_bakar.length == 0) {
      toast.error(ValidateRequiredMessage.dataPenggunaan.bahan_bakar)

      return false
    }

    if (store.dataKebutuhan == '2') {
      const temp_peralatan = store.dataPenggunaan.peralatan.filter(item => item.value != '' && parseInt(item.value) > 0)
      if (temp_peralatan.length == 0) {
        toast.error(ValidateRequiredMessage.dataPenggunaan.peralatan)

        return false
      }
    }

    return true
  }

  const formValidatePernyataan = () => {
    if (
      !store.dataPernyataan.pernyataan_1 ||
      !store.dataPernyataan.pernyataan_2 ||
      !store.dataPernyataan.pernyataan_3
    ) {
      toast.error(ValidateRequiredMessage.dataPernyataan)

      return false
    }

    return true
  }

  const getStepContent = step => {
    switch (step) {
      case 0:
        return <KebutuhanKomponen />
      case 1:
        return <FormLokasiPemasangan />
      case 2:
        return <FormPengguaanIdentitas />
      case 3:
        return <FormReview />
      case 4:
        return <FormBerhasil />
      default:
        return <FormReview />
    }
  }

  const renderContent = () => {
    if (activeStep === steps.length) {
      return (
        <Fragment>
          <LoadingSubmit />
          {/* <AlertDataDuplicate /> */}
          <AlertSubmitSuccess />
          <AlertSubmitFailed />
          <AlertSubmitConfirm />

          <Grid
            container
            spacing={5}
            style={{ display: 'flex', justifyContent: 'center', position: 'relative', height: '100%' }}
          >
            {getStepContent(activeStep)}
          </Grid>
        </Fragment>
      )
    } else {
      return (
        <form onSubmit={e => e.preventDefault()} style={{ height: '100%', width: '100%' }}>
          <Grid
            container
            spacing={5}
            style={{ display: 'flex', justifyContent: 'center', position: 'relative', height: '100%' }}
          >
            <LoadingSubmit />
            {/* <AlertDataDuplicate /> */}
            <AlertSubmitSuccess />
            <AlertSubmitFailed />
            <AlertSubmitConfirm />

            {getStepContent(activeStep)}

            {activeStep != 4 ? (
              <Grid item xs={12} id='grid_button'>
                <Button
                  variant='outlined'
                  color='secondary'
                  size='small'
                  onClick={handleBack}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  <span style={{ fontSize: '14px' }}>Kembali</span>
                </Button>

                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={handleNext}
                  sx={{ ml: 5 }}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  <span style={{ fontSize: '14px' }}>{activeStep === 3 ? 'Daftar' : 'Lanjut'}</span>
                </Button>
              </Grid>
            ) : (
              ''
            )}
          </Grid>
        </form>
      )
    }
  }

  const KebutuhanKomponen = () => {
    return (
      <Fragment>
        <div id='card_registrasi' style={{ marginLeft: '20px', marginTop: '40px' }}>
          <h1>Kebutuhan Anda untuk berlangganan GasKita adalah?</h1>

          <RadioGroup
            row
            value={radioKebutuhan}
            name='simple-radio'
            onChange={changeRadioKebutuhan}
            aria-label='simple-radio'
          >
            <FormControlLabel
              value='1'
              control={<Radio color='success' />}
              label={
                <Typography style={{ color: 'white', fontSize: '12pt' }}>Kebutuhan Sendiri/Rumah Tangga</Typography>
              }
            />
            <FormControlLabel
              value='2'
              control={<Radio color='success' />}
              label={
                <Typography style={{ color: 'white', fontSize: '12pt' }}>
                  Kebutuhan Komersial/Jasa (tempat makan, laundry, perkantoran, dan lainnya)
                </Typography>
              }
            />
          </RadioGroup>
        </div>
      </Fragment>
    )
  }

  const AlertDataDuplicate = () => {
    return (
      <Fragment>
        <Dialog
          open={openDuplicate}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseDuplicate()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid item xs={12} sm={4} style={{ textAlign: 'center' }}>
              <img
                src={heroPackagePGN.src}
                alt=''
                id='img_heroPackagePGN'
                style={{ paddingTop: '10px', paddingBottom: '10px' }}
              ></img>
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Informasi Pendaftaran
              </DialogTitle>
              <DialogContent>
                <DialogContentText id='alert-submit-description'>
                  Pelanggan yang terhormat, data anda sudah digunakan untuk pendaftaran sebelumnya dan pada saat ini
                  sedang dalam proses persetujuan. Silakan cek status menggunakan PGN Mobile
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='outlined'
                  color='primary'
                  size='small'
                  onClick={handleCloseDuplicate}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Kembali
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const AlertSubmitSuccess = () => {
    return (
      <Fragment>
        <Dialog
          open={openSuccess}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseSuccess()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img src={successPGN.src} alt='' id='img_successPGN' style={{ paddingTop: '30px', width: '150px' }} />
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Sukses Melakukan Pendaftaran
              </DialogTitle>
              <DialogContent>
                <DialogContentText id='alert-submit-description'>
                  Terima Kasih Anda telah berhasil mengajukan pendaftaran berlangganan GasKita PGN dan akan segera
                  diproses lebih lanjut. Silakan cek progress berlangganan Anda di Aplikasi PGN Mobile dengan link
                  tutorial{' '}
                  <a href='pgn.id/resetdanprogres' target='_blank'>
                    pgn.id/resetdanprogres
                  </a>
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={handleCloseSuccess}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Lanjutkan
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const AlertSubmitFailed = () => {
    return (
      <Fragment>
        <Dialog
          open={openFailed}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseFailed()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img src={failedPGN.src} alt='' id='img_failedPGN' style={{ paddingTop: '30px', width: '150px' }} />
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Gagal Melakukan Pendaftaran
              </DialogTitle>
              <DialogContent>
                <DialogContentText id='alert-submit-description'>
                  Pendaftaran Anda gagal tersimpan, silakan mencoba beberapa saat lagi. Informasi lebih lanjut hubungi
                  Pertamina Call Center 135 atau WhatsApp 08151-1500645 (hanya menerima pesan)
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='outlined'
                  color='primary'
                  size='small'
                  onClick={handleCloseFailed}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  OK
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const AlertSubmitConfirm = () => {
    return (
      <Fragment>
        <Dialog
          open={openConfirm}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseConfirm()
            }
          }}
        >
          <Grid container spacing={5}>
            <Grid
              item
              xs={12}
              sm={4}
              style={{ textAlign: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}
            >
              <img src={warningPGN.src} alt='' id='img_warningPGN' style={{ paddingTop: '30px', width: '150px' }} />
            </Grid>

            <Grid item xs={12} sm={8}>
              <DialogTitle id='alert-submit-title' color={'primary'} fontSize={'15pt'}>
                Konfirmasi Pendaftaran
              </DialogTitle>
              <DialogContent>
                <DialogContentText id='alert-submit-description'>
                  Pastikan Anda telah mengisi data dengan BENAR dan LENGKAP, karena dokumen perikatan/perjanjian akan
                  diterbitkan dan disampaikan secara elektronik. Apabila Anda melakukan kesalahan input data agar
                  melakukan registrasi ulang.
                </DialogContentText>
              </DialogContent>

              <DialogActions className='submit-actions-dense'>
                <Button
                  variant='outlined'
                  color='primary'
                  size='small'
                  onClick={() => setOpenConfirm(false)}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Kembali
                </Button>
                <Button
                  variant='contained'
                  color='success'
                  size='small'
                  onClick={handleCloseConfirm}
                  style={{ borderRadius: '25px', width: '130px' }}
                >
                  Lanjutkan Pendaftaran
                </Button>
              </DialogActions>
            </Grid>
          </Grid>
        </Dialog>
      </Fragment>
    )
  }

  const CircularProgressIndeterminate = styled(CircularProgress)(({ theme }) => ({
    left: 0,
    position: 'relative',
    animationDuration: '1000ms',
    color: theme.palette.mode === 'light' ? '#1a90ff' : '#308fe8'
  }))

  const LoadingSubmit = () => {
    return (
      <Fragment>
        <Dialog
          open={openSubmit}
          disableEscapeKeyDown
          aria-labelledby='alert-submit-title'
          aria-describedby='alert-submit-description'
          onClose={(event, reason) => {
            if (reason !== 'backdropClick') {
              handleCloseSubmit()
            }
          }}
        >
          <DialogContent style={{ textAlign: 'center' }}>
            <Box
              sx={{
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                position: 'relative'
              }}
            >
              <CircularProgressIndeterminate variant='indeterminate' disableShrink size={50} thickness={5} />
            </Box>
            <p style={{ color: 'primary', fontSize: '12pt' }}>Menyimpan Data...</p>
          </DialogContent>
        </Dialog>
      </Fragment>
    )
  }

  return (
    <Fragment>
      {activeStep != 4 ? (
        <div id='div_parent_step'>
          <StepperWrapper id='div_child_step'>
            <Stepper activeStep={activeStep} alternativeLabel>
              {steps.map((step, index) => {
                if (index != 4) {
                  return (
                    <Step key={index}>
                      <StepLabel StepIconComponent={StepperCustomDot}>
                        <div className='step-label'>
                          <div>
                            <Typography className='step-title' style={{ color: 'white', fontSize: '10pt' }}>
                              {step.title}
                            </Typography>
                          </div>
                        </div>
                      </StepLabel>
                    </Step>
                  )
                }
              })}
            </Stepper>
          </StepperWrapper>
        </div>
      ) : (
        <Fragment>
          <div style={{ display: 'flex', justifyContent: 'center', color: 'white' }}>
            <h1>Informasi Produk</h1>
          </div>
        </Fragment>
      )}

      <Card
        sx={{ mt: 4 }}
        style={{ backgroundColor: '#3C6DB2', minHeight: '500px', height: heightCard, color: 'white' }}
      >
        <CardContent style={{ height: '100%' }}>
          <div style={{ display: 'flex', width: '100%', height: '100%' }}>
            {activeStep == 0 && <img src={heroManPGN.src} alt='' id='img_heroManPGN'></img>}

            {renderContent()}
            {activeStep == 0 && (
              <Fragment>
                <img src={heroPipePGN.src} alt='' id='heroPipePGN'></img>
                <img src={heroWomanPGN.src} alt='' id='heroWomanPGN'></img>
              </Fragment>
            )}
          </div>
        </CardContent>
      </Card>

      <div style={{ display: 'flex', justifyContent: 'center', alignItems: 'center', marginTop: '15px' }}>
        <Button
          variant='contained'
          color='error'
          style={{ backgroundColor: '#BA313B', marginRight: '10px', fontSize: '10pt' }}
          size='small'
          onClick={handleDownloadBrosur}
        >
          Unduh Brosur
        </Button>
        {/* <img src={textGaskitaWhite.src} alt='' style={{ width: '100px' }}></img> */}
      </div>
    </Fragment>
  )
}

export default StepperRegister
